/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.introspection.ClassMap;

public class Introspector {
    public static final String CACHEDUMP_MSG = "Introspector : detected classloader change. Dumping cache.";
    private RuntimeServices rsvc = null;
    private final Map classMethodMaps = new HashMap();
    private Set cachedClassNames = new HashSet();

    public Method getMethod(Class c, String name, Object[] params) throws Exception {
        if (c == null) {
            throw new Exception("Introspector.getMethod(): Class method key was null: " + name);
        }
        ClassMap classMap = null;
        Map map = this.classMethodMaps;
        synchronized (map) {
            classMap = (ClassMap)this.classMethodMaps.get(c);
            if (classMap == null) {
                if (this.cachedClassNames.contains(c.getName())) {
                    this.clearCache();
                    this.rsvc.info(CACHEDUMP_MSG);
                }
                classMap = this.createClassMap(c);
            }
        }
        return classMap.findMethod(name, params);
    }

    private ClassMap createClassMap(Class c) {
        ClassMap classMap = new ClassMap(c);
        this.classMethodMaps.put(c, classMap);
        this.cachedClassNames.add(c.getName());
        return classMap;
    }

    private void clearCache() {
        this.classMethodMaps.clear();
        this.cachedClassNames = new HashSet();
    }

    public Introspector(RuntimeServices r) {
        this.rsvc = r;
    }
}

