/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.app.tools;

import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Vector;
import org.apache.velocity.context.Context;

public class VelocityFormatter {
    Context context = null;
    NumberFormat nf = NumberFormat.getInstance();

    public String formatShortDate(Date date) {
        return DateFormat.getDateInstance(3).format(date);
    }

    public String formatLongDate(Date date) {
        return DateFormat.getDateInstance(1).format(date);
    }

    public String formatShortDateTime(Date date) {
        return DateFormat.getDateTimeInstance(3, 3).format(date);
    }

    public String formatLongDateTime(Date date) {
        return DateFormat.getDateTimeInstance(1, 1).format(date);
    }

    public String formatArray(Object array) {
        return this.formatArray(array, ", ", " and ");
    }

    public String formatArray(Object array, String delim) {
        return this.formatArray(array, delim, delim);
    }

    public String formatArray(Object array, String delim, String finaldelim) {
        StringBuffer sb = new StringBuffer();
        int arrayLen = Array.getLength(array);
        int i = 0;
        while (i < arrayLen) {
            sb.append(Array.get(array, i).toString());
            if (i < arrayLen - 2) {
                sb.append(delim);
            } else if (i < arrayLen - 1) {
                sb.append(finaldelim);
            }
            ++i;
        }
        return sb.toString();
    }

    public String formatVector(Vector vector) {
        return this.formatVector(vector, ", ", " and ");
    }

    public String formatVector(Vector vector, String delim) {
        return this.formatVector(vector, delim, delim);
    }

    public String formatVector(Vector vector, String delim, String finaldelim) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < vector.size()) {
            sb.append(vector.elementAt(i).toString());
            if (i < vector.size() - 2) {
                sb.append(delim);
            } else if (i < vector.size() - 1) {
                sb.append(finaldelim);
            }
            ++i;
        }
        return sb.toString();
    }

    public String limitLen(int maxlen, String string) {
        return this.limitLen(maxlen, string, "...");
    }

    public String limitLen(int maxlen, String string, String suffix) {
        String ret = string;
        if (string.length() > maxlen) {
            ret = string.substring(0, maxlen - suffix.length()) + suffix;
        }
        return ret;
    }

    public String makeAlternator(String name, String alt1, String alt2) {
        String[] alternates = new String[]{alt1, alt2};
        this.context.put(name, new VelocityAlternator(alternates));
        return "";
    }

    public String makeAlternator(String name, String alt1, String alt2, String alt3) {
        String[] alternates = new String[]{alt1, alt2, alt3};
        this.context.put(name, new VelocityAlternator(alternates));
        return "";
    }

    public String makeAlternator(String name, String alt1, String alt2, String alt3, String alt4) {
        String[] alternates = new String[]{alt1, alt2, alt3, alt4};
        this.context.put(name, new VelocityAlternator(alternates));
        return "";
    }

    public String makeAutoAlternator(String name, String alt1, String alt2) {
        String[] alternates = new String[]{alt1, alt2};
        this.context.put(name, new VelocityAutoAlternator(this, alternates));
        return "";
    }

    public Object isNull(Object o, Object dflt) {
        if (o == null) {
            return dflt;
        }
        return o;
    }

    public VelocityFormatter(Context context) {
        this.context = context;
    }

    public class VelocityAlternator {
        protected String[] alternates = null;
        protected int current = 0;

        public String alternate() {
            ++this.current;
            this.current %= this.alternates.length;
            return "";
        }

        public String toString() {
            return this.alternates[this.current];
        }

        public VelocityAlternator(String[] alternates) {
            this.alternates = alternates;
        }
    }

    public class VelocityAutoAlternator
    extends VelocityAlternator {
        private final /* synthetic */ VelocityFormatter this$0;

        public final String toString() {
            String s = this.alternates[this.current];
            this.alternate();
            return s;
        }

        public VelocityAutoAlternator(VelocityFormatter velocityFormatter, String[] alternates) {
            VelocityFormatter velocityFormatter2 = velocityFormatter;
            if (velocityFormatter2 == null) {
                throw null;
            }
            super(alternates);
            this.this$0 = velocityFormatter;
        }
    }
}

