/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io.rotate;

import java.io.File;
import org.apache.log.output.io.rotate.RotateStrategy;

public class OrRotateStrategy
implements RotateStrategy {
    private RotateStrategy[] m_strategies;
    private int m_usedRotation = -1;

    public void reset() {
        if (-1 != this.m_usedRotation) {
            this.m_strategies[this.m_usedRotation].reset();
            this.m_usedRotation = -1;
        }
    }

    public boolean isRotationNeeded(String data, File file) {
        this.m_usedRotation = -1;
        if (this.m_strategies != null) {
            int length = this.m_strategies.length;
            int i = 0;
            while (i < length) {
                if (this.m_strategies[i].isRotationNeeded(data, file)) {
                    this.m_usedRotation = i;
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public OrRotateStrategy(RotateStrategy[] strategies) {
        this.m_strategies = strategies;
    }
}

