/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class StreamTarget
extends AbstractOutputTarget {
    private OutputStream m_outputStream;

    protected synchronized void setOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream property must not be null");
        }
        this.m_outputStream = outputStream;
    }

    protected synchronized void write(String data) {
        OutputStream outputStream = this.m_outputStream;
        if (outputStream == null) {
            String message = "Attempted to write data '" + data + "' to Null OutputStream";
            this.getErrorHandler().error(message, null, null);
            return;
        }
        try {
            outputStream.write(data.getBytes());
            outputStream.flush();
        }
        catch (IOException ioe) {
            String message = "Error writing data '" + data + "' to OutputStream";
            this.getErrorHandler().error(message, ioe, null);
        }
    }

    public synchronized void close() {
        super.close();
        this.shutdownStream();
    }

    protected synchronized void shutdownStream() {
        OutputStream outputStream = this.m_outputStream;
        this.m_outputStream = null;
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException ioe) {
            this.getErrorHandler().error("Error closing OutputStream", ioe, null);
        }
    }

    public StreamTarget(OutputStream outputStream, Formatter formatter) {
        super(formatter);
        if (outputStream != null) {
            this.setOutputStream(outputStream);
            this.open();
        }
    }
}

