/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CloseableReadWriteLock {
    @NotNull
    private final ReadLock readLock;
    @NotNull
    private final ReentrantReadWriteLock readWriteLock;
    @NotNull
    private final WriteLock writeLock;

    public CloseableReadWriteLock() {
        this(false);
    }

    public CloseableReadWriteLock(boolean fair) {
        this.readWriteLock = new ReentrantReadWriteLock(fair);
        this.readLock = new ReadLock(this.readWriteLock.readLock());
        this.writeLock = new WriteLock(this.readWriteLock.writeLock());
    }

    @NotNull
    public WriteLock lockWrite() {
        this.readWriteLock.writeLock().lock();
        return this.writeLock;
    }

    @NotNull
    public WriteLock lockWriteInterruptibly() throws InterruptedException {
        this.readWriteLock.writeLock().lockInterruptibly();
        return this.writeLock;
    }

    @NotNull
    public WriteLock tryLockWrite(long waitTime, @NotNull TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (waitTime <= 0L) {
            Validator.violation("CloseableLock.tryLockWrite.waitTime must be greater than zero.  The provided value was " + waitTime);
        }
        if (this.readWriteLock.writeLock().tryLock(waitTime, timeUnit)) {
            return this.writeLock;
        }
        throw new TimeoutException(UtilityMessages.ERR_CLOSEABLE_RW_LOCK_TRY_LOCK_WRITE_TIMEOUT.get(StaticUtils.millisToHumanReadableDuration(timeUnit.toMillis(waitTime))));
    }

    @NotNull
    public ReadLock lockRead() {
        this.readWriteLock.readLock().lock();
        return this.readLock;
    }

    @NotNull
    public ReadLock lockReadInterruptibly() throws InterruptedException {
        this.readWriteLock.readLock().lockInterruptibly();
        return this.readLock;
    }

    @NotNull
    public ReadLock tryLockRead(long waitTime, @NotNull TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (waitTime <= 0L) {
            Validator.violation("CloseableLock.tryLockRead.waitTime must be greater than zero.  The provided value was " + waitTime);
        }
        if (this.readWriteLock.readLock().tryLock(waitTime, timeUnit)) {
            return this.readLock;
        }
        throw new TimeoutException(UtilityMessages.ERR_CLOSEABLE_RW_LOCK_TRY_LOCK_READ_TIMEOUT.get(StaticUtils.millisToHumanReadableDuration(timeUnit.toMillis(waitTime))));
    }

    public boolean isFair() {
        return this.readWriteLock.isFair();
    }

    public boolean isWriteLocked() {
        return this.readWriteLock.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.readWriteLock.isWriteLockedByCurrentThread();
    }

    public int getWriteHoldCount() {
        return this.readWriteLock.getWriteHoldCount();
    }

    public int getReadLockCount() {
        return this.readWriteLock.getReadLockCount();
    }

    public int getReadHoldCount() {
        return this.readWriteLock.getReadHoldCount();
    }

    public boolean hasQueuedThreads() {
        return this.readWriteLock.hasQueuedThreads();
    }

    public boolean hasQueuedThread(@NotNull Thread thread) {
        return this.readWriteLock.hasQueuedThread(thread);
    }

    public int getQueueLength() {
        return this.readWriteLock.getQueueLength();
    }

    @NotNull
    public String toString() {
        return "CloseableReadWriteLock(lock=" + this.readWriteLock.toString() + ')';
    }

    public final class WriteLock
    implements Closeable {
        @NotNull
        private final ReentrantReadWriteLock.WriteLock lock;

        private WriteLock(ReentrantReadWriteLock.WriteLock lock) {
            this.lock = lock;
        }

        public void avoidCompilerWarning() {
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }

    public final class ReadLock
    implements Closeable {
        @NotNull
        private final ReentrantReadWriteLock.ReadLock lock;

        private ReadLock(ReentrantReadWriteLock.ReadLock lock) {
            this.lock = lock;
        }

        public void avoidCompilerWarning() {
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }
}

