/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.matchers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.Set;
import org.apache.james.core.MailAddress;
import org.apache.james.mailetcontainer.impl.matchers.GenericCompositeMatcher;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;

public class And
extends GenericCompositeMatcher {
    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        ImmutableList<Set<MailAddress>> individualMatchedResults = this.performMatchOnMatchers(mail);
        return this.computeIntersection(individualMatchedResults);
    }

    private Set<MailAddress> computeIntersection(ImmutableList<Set<MailAddress>> individualMatchedResults) {
        if (individualMatchedResults.isEmpty()) {
            return ImmutableSet.of();
        }
        if (individualMatchedResults.size() == 1) {
            return (Set)individualMatchedResults.get(0);
        }
        return Sets.intersection((Set)((Set)individualMatchedResults.get(0)), this.computeIntersection((ImmutableList<Set<MailAddress>>)individualMatchedResults.subList(1, individualMatchedResults.size())));
    }

    private ImmutableList<Set<MailAddress>> performMatchOnMatchers(Mail mail) throws MessagingException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Matcher matcher : this.getMatchers()) {
            Collection matchedMailAddress = matcher.match(mail);
            if (matchedMailAddress != null && !matchedMailAddress.isEmpty()) {
                builder.add((Object)ImmutableSet.copyOf((Collection)matchedMailAddress));
                continue;
            }
            return ImmutableList.of();
        }
        return builder.build();
    }
}

