/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jpa.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.core.Username;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.model.Algorithm;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;

@Entity(name="JamesUser")
@Table(name="JAMES_USER")
@NamedQueries(value={@NamedQuery(name="findUserByName", query="SELECT user FROM JamesUser user WHERE user.name=:name"), @NamedQuery(name="deleteUserByName", query="DELETE FROM JamesUser user WHERE user.name=:name"), @NamedQuery(name="containsUser", query="SELECT COUNT(user) FROM JamesUser user WHERE user.name=:name"), @NamedQuery(name="countUsers", query="SELECT COUNT(user) FROM JamesUser user"), @NamedQuery(name="listUserNames", query="SELECT user.name FROM JamesUser user")})
public class JPAUser
implements User,
PersistenceCapable {
    @Version
    private int version;
    @Id
    @Column(name="USER_NAME", nullable=false, length=100)
    private String name;
    @Basic
    @Column(name="PASSWORD", nullable=false, length=128)
    private String password;
    @Basic
    @Column(name="PASSWORD_HASH_ALGORITHM", nullable=false, length=100)
    private String alg;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient boolean pcVersionInit;
    protected transient StateManager pcStateManager;
    private transient Object pcDetachedState;

    @VisibleForTesting
    static String hashPassword(String password, String nullableSalt, String nullableAlgorithm) {
        Algorithm algorithm = JPAUser.buildAlgorithm(nullableAlgorithm);
        if (algorithm.isPBKDF2()) {
            return algorithm.digest(password, nullableSalt);
        }
        Object credentials = password;
        if (algorithm.isSalted() && nullableSalt != null) {
            credentials = nullableSalt + password;
        }
        return (String)JPAUser.chooseHashFunction(algorithm.getName()).apply(credentials);
    }

    private static Algorithm buildAlgorithm(String nullableAlgorithm) {
        return Algorithm.of((String)Optional.ofNullable(nullableAlgorithm).orElse("SHA-512"));
    }

    public String getPasswordHash() {
        return JPAUser.pcGetpassword(this);
    }

    public Algorithm getAlgorithm() {
        return JPAUser.buildAlgorithm(JPAUser.pcGetalg(this));
    }

    private static PasswordHashFunction chooseHashFunction(String algorithm) {
        switch (algorithm) {
            case "NONE": {
                return password -> password;
            }
        }
        return password -> JPAUser.chooseHashing(algorithm).hashString((CharSequence)password, StandardCharsets.UTF_8).toString();
    }

    private static HashFunction chooseHashing(String algorithm) {
        switch (algorithm) {
            case "MD5": {
                return Hashing.md5();
            }
            case "SHA-256": {
                return Hashing.sha256();
            }
            case "SHA-512": {
                return Hashing.sha512();
            }
            case "SHA-1": 
            case "SHA1": {
                return Hashing.sha1();
            }
        }
        return Hashing.sha512();
    }

    protected JPAUser() {
    }

    public JPAUser(String userName, String password, String alg) {
        this.name = userName;
        this.alg = alg;
        this.password = JPAUser.hashPassword(password, userName, alg);
    }

    public Username getUserName() {
        return Username.of((String)JPAUser.pcGetname(this));
    }

    public boolean setPassword(String newPass) {
        boolean result;
        if (newPass == null) {
            result = false;
        } else {
            JPAUser.pcSetpassword(this, JPAUser.hashPassword(newPass, JPAUser.pcGetname(this), JPAUser.pcGetalg(this)));
            result = true;
        }
        return result;
    }

    public boolean verifyPassword(String pass) {
        boolean result = pass == null ? JPAUser.pcGetpassword(this) == null : JPAUser.pcGetpassword(this) != null && JPAUser.pcGetpassword(this).equals(JPAUser.hashPassword(pass, JPAUser.pcGetname(this), JPAUser.pcGetalg(this)));
        return result;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (JPAUser.pcGetname(this) == null ? 0 : JPAUser.pcGetname(this).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JPAUser other = (JPAUser)obj;
        return !(JPAUser.pcGetname(this) == null ? JPAUser.pcGetname(other) != null : !JPAUser.pcGetname(this).equals(JPAUser.pcGetname(other)));
    }

    public String toString() {
        return "[User " + JPAUser.pcGetname(this) + "]";
    }

    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcFieldNames = new String[]{"alg", "name", "password", "version"};
        pcFieldTypes = new Class[]{String.class, String.class, String.class, Integer.TYPE};
        pcFieldFlags = new byte[]{26, 26, 26, 21};
        PCRegistry.register(JPAUser.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JamesUser", (PersistenceCapable)new JPAUser());
    }

    protected void pcClearFields() {
        this.alg = null;
        this.name = null;
        this.password = null;
        this.version = 0;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAUser jPAUser = new JPAUser();
        if (bl) {
            jPAUser.pcClearFields();
        }
        jPAUser.pcStateManager = stateManager;
        jPAUser.pcCopyKeyFieldsFromObjectId(object);
        return jPAUser;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAUser jPAUser = new JPAUser();
        if (bl) {
            jPAUser.pcClearFields();
        }
        jPAUser.pcStateManager = stateManager;
        return jPAUser;
    }

    protected static int pcGetManagedFieldCount() {
        return 4;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.alg = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.version = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                this.pcVersionInit = true;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.alg);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 3: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.version);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAUser jPAUser, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.alg = jPAUser.alg;
                return;
            }
            case 1: {
                this.name = jPAUser.name;
                return;
            }
            case 2: {
                this.password = jPAUser.password;
                return;
            }
            case 3: {
                this.version = jPAUser.version;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JPAUser jPAUser = (JPAUser)object;
        if (jPAUser.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAUser, nArray[i]);
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return new Integer(this.version);
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(1 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.name = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new StringId(JPAUser.class, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new StringId(JPAUser.class, this.name);
    }

    private static final String pcGetalg(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.alg;
        }
        int n = pcInheritedFieldCount + 0;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.alg;
    }

    private static final void pcSetalg(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.alg = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 0, jPAUser.alg, string, 0);
    }

    private static final String pcGetname(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.name;
        }
        int n = pcInheritedFieldCount + 1;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.name;
    }

    private static final void pcSetname(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.name = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 1, jPAUser.name, string, 0);
    }

    private static final String pcGetpassword(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.password;
        }
        int n = pcInheritedFieldCount + 2;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.password;
    }

    private static final void pcSetpassword(JPAUser jPAUser, String string) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.password = string;
            return;
        }
        jPAUser.pcStateManager.settingStringField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 2, jPAUser.password, string, 0);
    }

    private static final int pcGetversion(JPAUser jPAUser) {
        if (jPAUser.pcStateManager == null) {
            return jPAUser.version;
        }
        int n = pcInheritedFieldCount + 3;
        jPAUser.pcStateManager.accessingField(n);
        return jPAUser.version;
    }

    private static final void pcSetversion(JPAUser jPAUser, int n) {
        if (jPAUser.pcStateManager == null) {
            jPAUser.version = n;
            jPAUser.pcVersionInit = true;
            return;
        }
        jPAUser.pcStateManager.settingIntField((PersistenceCapable)jPAUser, pcInheritedFieldCount + 3, jPAUser.version, n, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.version != 0) {
            return Boolean.TRUE;
        }
        if (this.pcVersionInit) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    static interface PasswordHashFunction
    extends Function<String, String> {
    }
}

