/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.nio.channels.NetworkChannel;

public class MulticastTest {
    protected static final InetAddress group;
    protected static final InetAddress bind_addr;
    protected static final int PORT = 6789;

    public static void main(String[] args) throws Exception {
        MulticastTest test = new MulticastTest();
        if (args.length > 0 && args[0].equalsIgnoreCase("-nio")) {
            MulticastTest.testDatagramChannel();
        } else {
            MulticastTest.testMulticastSocket();
        }
    }

    protected static void testMulticastSocket() throws IOException {
        MulticastSocket sock = new MulticastSocket(new InetSocketAddress(6789));
        NetworkInterface ni = NetworkInterface.getByInetAddress(bind_addr);
        sock.setNetworkInterface(ni);
        sock.joinGroup(new InetSocketAddress(group, 6789), ni);
        System.out.printf("%s: local=%s, remote=%s\n", sock.getClass().getSimpleName(), sock.getLocalSocketAddress(), sock.getRemoteSocketAddress());
    }

    protected static void testDatagramChannel() throws IOException {
        NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
        NetworkChannel dc = ((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(new InetSocketAddress(6789)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, ni);
        MembershipKey key = dc.join(group, ni);
        System.out.println("key = " + key);
    }

    static {
        try {
            group = InetAddress.getByName("239.5.5.5");
            bind_addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

