/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.postgres;

import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.user.lib.model.Algorithm;

public class PostgresUsersRepositoryConfiguration {
    public static final String DEFAULT_ALGORITHM = "PBKDF2-SHA512";
    public static final String DEFAULT_HASHING_MODE = Algorithm.HashingMode.PLAIN.name();
    public static final PostgresUsersRepositoryConfiguration DEFAULT = new PostgresUsersRepositoryConfiguration(Algorithm.of((String)"PBKDF2-SHA512"), Algorithm.HashingMode.parse((String)DEFAULT_HASHING_MODE));
    private final Algorithm preferredAlgorithm;
    private final Algorithm.HashingMode fallbackHashingMode;

    public PostgresUsersRepositoryConfiguration(Algorithm preferredAlgorithm, Algorithm.HashingMode fallbackHashingMode) {
        this.preferredAlgorithm = preferredAlgorithm;
        this.fallbackHashingMode = fallbackHashingMode;
    }

    public Algorithm getPreferredAlgorithm() {
        return this.preferredAlgorithm;
    }

    public Algorithm.HashingMode getFallbackHashingMode() {
        return this.fallbackHashingMode;
    }

    public static PostgresUsersRepositoryConfiguration from(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        return new PostgresUsersRepositoryConfiguration(Algorithm.of((String)config.getString("algorithm", DEFAULT_ALGORITHM)), Algorithm.HashingMode.parse((String)config.getString("hashingMode", DEFAULT_HASHING_MODE)));
    }
}

