/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.cassandra.mail.task.ConflictingEntry;
import org.apache.james.mailbox.cassandra.mail.task.SolveMailboxInconsistenciesTask;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;

public class SolveMailboxInconsistenciesTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final long processedMailboxEntries;
    private final long processedMailboxPathEntries;
    private final ImmutableList<String> fixedInconsistencies;
    private final ImmutableList<ConflictingEntry> conflictingEntries;
    private final long errors;
    private final Instant timestamp;

    private static SolveMailboxInconsistenciesTaskAdditionalInformationDTO fromDomainObject(SolveMailboxInconsistenciesTask.Details details, String type) {
        return new SolveMailboxInconsistenciesTaskAdditionalInformationDTO(type, details.getProcessedMailboxEntries(), details.getProcessedMailboxPathEntries(), details.getFixedInconsistencies(), details.getConflictingEntries(), details.getErrors(), details.timestamp());
    }

    public static AdditionalInformationDTOModule<SolveMailboxInconsistenciesTask.Details, SolveMailboxInconsistenciesTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(SolveMailboxInconsistenciesTask.Details.class).convertToDTO(SolveMailboxInconsistenciesTaskAdditionalInformationDTO.class).toDomainObjectConverter(SolveMailboxInconsistenciesTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(SolveMailboxInconsistenciesTaskAdditionalInformationDTO::fromDomainObject).typeName(SolveMailboxInconsistenciesTask.SOLVE_MAILBOX_INCONSISTENCIES.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    public SolveMailboxInconsistenciesTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="processedMailboxEntries") long processedMailboxEntries, @JsonProperty(value="processedMailboxPathEntries") long processedMailboxPathEntries, @JsonProperty(value="fixedInconsistencies") ImmutableList<String> fixedInconsistencies, @JsonProperty(value="conflictingEntries") ImmutableList<ConflictingEntry> conflictingEntries, @JsonProperty(value="errors") long errors, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.processedMailboxEntries = processedMailboxEntries;
        this.timestamp = timestamp;
        this.processedMailboxPathEntries = processedMailboxPathEntries;
        this.fixedInconsistencies = fixedInconsistencies;
        this.conflictingEntries = conflictingEntries;
        this.errors = errors;
    }

    public long getProcessedMailboxEntries() {
        return this.processedMailboxEntries;
    }

    public long getProcessedMailboxPathEntries() {
        return this.processedMailboxPathEntries;
    }

    public ImmutableList<String> getFixedInconsistencies() {
        return this.fixedInconsistencies;
    }

    public ImmutableList<ConflictingEntry> getConflictingEntries() {
        return this.conflictingEntries;
    }

    public long getErrors() {
        return this.errors;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    private SolveMailboxInconsistenciesTask.Details toDomainObject() {
        return new SolveMailboxInconsistenciesTask.Details(this.timestamp, this.processedMailboxEntries, this.processedMailboxPathEntries, this.fixedInconsistencies, this.conflictingEntries, this.errors);
    }
}

