/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.mail.internet.AddressException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DeniedEntityType;
import org.apache.james.droplists.api.DropList;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.OwnerScope;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import reactor.core.publisher.Flux;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

public class DropListRoutes
implements Routes {
    public static final String DROP_LIST = "/droplist";
    public static final String OWNER_SCOPE = ":ownerScope";
    public static final String OWNER = ":owner";
    public static final String DENIED_ENTITY = ":deniedEntity";
    public static final String DENIED_ENTITY_TYPE = "deniedEntityType";
    private final DropList dropList;
    private final JsonTransformer jsonTransformer;

    @Inject
    public DropListRoutes(DropList dropList, JsonTransformer jsonTransformer) {
        this.dropList = dropList;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return DROP_LIST;
    }

    public void define(Service service) {
        service.get("/droplist/:ownerScope", this::getDropList, (ResponseTransformer)this.jsonTransformer);
        service.get("/droplist/:ownerScope/:owner", this::getDropList, (ResponseTransformer)this.jsonTransformer);
        service.put("/droplist/:ownerScope/:owner/:deniedEntity", this::addDropListEntry);
        service.put("/droplist/:ownerScope/:deniedEntity", this::addDropListEntry);
        service.head("/droplist/:ownerScope/:owner/:deniedEntity", this::dropListEntryExist);
        service.head("/droplist/:ownerScope/:deniedEntity", this::dropListEntryExist);
        service.delete("/droplist/:ownerScope/:owner/:deniedEntity", this::removeDropListEntry);
        service.delete("/droplist/:ownerScope/:deniedEntity", this::removeDropListEntry);
    }

    public ImmutableSet<String> getDropList(Request request, Response response) {
        OwnerScope ownerScope = this.checkValidOwnerScope(request.params(OWNER_SCOPE));
        String owner = Optional.ofNullable(request.params(OWNER)).orElse("");
        Optional<DeniedEntityType> deniedEntityType = this.checkValidDeniedEntityType(request.queryParams(DENIED_ENTITY_TYPE));
        if (deniedEntityType.isPresent()) {
            return (ImmutableSet)this.dropList.list(ownerScope, owner).filter(deniedEntry -> deniedEntry.getDeniedEntityType().equals(deniedEntityType.get())).map(DropListEntry::getDeniedEntity).collect(ImmutableSet.toImmutableSet()).block();
        }
        return (ImmutableSet)this.dropList.list(ownerScope, owner).map(DropListEntry::getDeniedEntity).collect(ImmutableSet.toImmutableSet()).block();
    }

    public String addDropListEntry(Request request, Response response) {
        OwnerScope ownerScope = this.checkValidOwnerScope(request.params(OWNER_SCOPE));
        String owner = Optional.ofNullable(request.params(OWNER)).orElse("");
        String deniedEntity = request.params(DENIED_ENTITY);
        DropListEntry dropListEntry = this.getDropListEntry(ownerScope, owner, deniedEntity);
        this.dropList.add(dropListEntry).block();
        return Responses.returnNoContent((Response)response);
    }

    public String removeDropListEntry(Request request, Response response) {
        OwnerScope ownerScope = this.checkValidOwnerScope(request.params(OWNER_SCOPE));
        String owner = Optional.ofNullable(request.params(OWNER)).orElse("");
        String deniedEntity = request.params(DENIED_ENTITY);
        this.dropList.list(ownerScope, owner).filter(dropListEntry -> dropListEntry.getDeniedEntity().equals(deniedEntity)).collectList().doOnNext(this::deleteDropListEntry).block();
        return Responses.returnNoContent((Response)response);
    }

    public String dropListEntryExist(Request request, Response response) {
        OwnerScope ownerScope = this.checkValidOwnerScope(request.params(OWNER_SCOPE));
        String owner = Optional.ofNullable(request.params(OWNER)).orElse("");
        String deniedEntity = request.params(DENIED_ENTITY);
        boolean entryExists = (Boolean)this.dropList.list(ownerScope, owner).any(dropListEntry -> dropListEntry.getDeniedEntity().equals(deniedEntity)).block();
        if (entryExists) {
            response.status(204);
        } else {
            response.status(404);
        }
        return "";
    }

    private Optional<DeniedEntityType> checkValidDeniedEntityType(String deniedEntityType) {
        try {
            if (deniedEntityType == null || deniedEntityType.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(DeniedEntityType.valueOf((String)deniedEntityType.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid DeniedEntityType").cause((Exception)new IllegalArgumentException("DeniedEntityType '" + deniedEntityType + "' is invalid. Supported values are " + String.valueOf(EnumUtils.getEnumList(DeniedEntityType.class)))).haltError();
        }
    }

    private DropListEntry getDropListEntry(OwnerScope ownerScope, String owner, String deniedEntity) {
        DropListEntry.Builder dropListEntryBuilder = DropListEntry.builder();
        switch (ownerScope) {
            case GLOBAL: {
                dropListEntryBuilder = dropListEntryBuilder.forAll();
                break;
            }
            case DOMAIN: {
                dropListEntryBuilder = dropListEntryBuilder.domainOwner(this.checkValidDomain(owner));
                break;
            }
            case USER: {
                dropListEntryBuilder = dropListEntryBuilder.userOwner(DropListRoutes.checkValidMailAddress(owner));
            }
        }
        if (deniedEntity.contains("@")) {
            dropListEntryBuilder.denyAddress(DropListRoutes.checkValidMailAddress(deniedEntity));
        } else {
            dropListEntryBuilder.denyDomain(this.checkValidDomain(deniedEntity));
        }
        return dropListEntryBuilder.build();
    }

    private OwnerScope checkValidOwnerScope(String ownerScope) {
        try {
            return OwnerScope.valueOf((String)ownerScope.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid OwnerScope").cause((Exception)new IllegalArgumentException("OwnerScope '" + ownerScope + "' is invalid. Supported values are " + String.valueOf(EnumUtils.getEnumList(OwnerScope.class)))).haltError();
        }
    }

    private static MailAddress checkValidMailAddress(String address) {
        try {
            return new MailAddress(address);
        }
        catch (AddressException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid mail address %s", new Object[]{address}).cause((Exception)((Object)e)).haltError();
        }
    }

    private Domain checkValidDomain(String domainName) {
        try {
            return Domain.of((String)domainName);
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid domain %s", new Object[]{domainName}).cause((Exception)e).haltError();
        }
    }

    private void deleteDropListEntry(List<DropListEntry> dropListEntries) {
        Flux.fromIterable(dropListEntries).flatMap(arg_0 -> ((DropList)this.dropList).remove(arg_0), 16).then().block();
    }
}

