/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RegisterYubiKeyOTPDeviceExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String REGISTER_YUBIKEY_OTP_DEVICE_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.54";
    private static final byte TYPE_AUTHENTICATION_ID = -128;
    private static final byte TYPE_STATIC_PASSWORD = -127;
    private static final byte TYPE_YUBIKEY_OTP = -126;
    private static final long serialVersionUID = 4833523148133015294L;
    @Nullable
    private final ASN1OctetString staticPassword;
    @Nullable
    private final String authenticationID;
    @NotNull
    private final String yubiKeyOTP;

    public RegisterYubiKeyOTPDeviceExtendedRequest(@NotNull String yubiKeyOTP, Control ... controls) {
        this(null, (ASN1OctetString)null, yubiKeyOTP, controls);
    }

    public RegisterYubiKeyOTPDeviceExtendedRequest(@Nullable String authenticationID, @Nullable String staticPassword, @NotNull String yubiKeyOTP, Control ... controls) {
        this(authenticationID, RegisterYubiKeyOTPDeviceExtendedRequest.encodePassword(staticPassword), yubiKeyOTP, controls);
    }

    public RegisterYubiKeyOTPDeviceExtendedRequest(@Nullable String authenticationID, @Nullable byte[] staticPassword, @NotNull String yubiKeyOTP, Control ... controls) {
        this(authenticationID, RegisterYubiKeyOTPDeviceExtendedRequest.encodePassword(staticPassword), yubiKeyOTP, controls);
    }

    private RegisterYubiKeyOTPDeviceExtendedRequest(@Nullable String authenticationID, @Nullable ASN1OctetString staticPassword, @NotNull String yubiKeyOTP, Control ... controls) {
        super(REGISTER_YUBIKEY_OTP_DEVICE_REQUEST_OID, RegisterYubiKeyOTPDeviceExtendedRequest.encodeValue(authenticationID, staticPassword, yubiKeyOTP), controls);
        this.authenticationID = authenticationID;
        this.staticPassword = staticPassword;
        this.yubiKeyOTP = yubiKeyOTP;
    }

    public RegisterYubiKeyOTPDeviceExtendedRequest(@NotNull ExtendedRequest request) throws LDAPException {
        super(request);
        ASN1OctetString value = request.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_REGISTER_YUBIKEY_OTP_REQUEST_NO_VALUE.get());
        }
        try {
            String authID = null;
            ASN1OctetString staticPW = null;
            String otp = null;
            block8: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        authID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block8;
                    }
                    case -127: {
                        staticPW = ASN1OctetString.decodeAsOctetString(e);
                        continue block8;
                    }
                    case -126: {
                        otp = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block8;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_REGISTER_YUBIKEY_OTP_REQUEST_UNRECOGNIZED_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            if (otp == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_REGISTER_YUBIKEY_OTP_REQUEST_MISSING_OTP.get());
            }
            this.authenticationID = authID;
            this.staticPassword = staticPW;
            this.yubiKeyOTP = otp;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_REGISTER_YUBIKEY_OTP_REQUEST_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Nullable
    static ASN1OctetString encodePassword(@Nullable Object password) {
        if (password == null) {
            return null;
        }
        if (password instanceof byte[]) {
            return new ASN1OctetString(-127, (byte[])password);
        }
        return new ASN1OctetString(-127, String.valueOf(password));
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable String authenticationID, @Nullable ASN1OctetString staticPassword, @NotNull String yubiKeyOTP) {
        Validator.ensureNotNull(yubiKeyOTP);
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(3);
        if (authenticationID != null) {
            elements.add(new ASN1OctetString(-128, authenticationID));
        }
        if (staticPassword != null) {
            elements.add(staticPassword);
        }
        elements.add(new ASN1OctetString(-126, yubiKeyOTP));
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Nullable
    public String getAuthenticationID() {
        return this.authenticationID;
    }

    @Nullable
    public String getStaticPasswordString() {
        if (this.staticPassword == null) {
            return null;
        }
        return this.staticPassword.stringValue();
    }

    @Nullable
    public byte[] getStaticPasswordBytes() {
        if (this.staticPassword == null) {
            return null;
        }
        return this.staticPassword.getValue();
    }

    @NotNull
    public String getYubiKeyOTP() {
        return this.yubiKeyOTP;
    }

    @Override
    @NotNull
    public RegisterYubiKeyOTPDeviceExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public RegisterYubiKeyOTPDeviceExtendedRequest duplicate(@Nullable Control[] controls) {
        RegisterYubiKeyOTPDeviceExtendedRequest r = new RegisterYubiKeyOTPDeviceExtendedRequest(this.authenticationID, this.staticPassword, this.yubiKeyOTP, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        r.setIntermediateResponseListener(this.getIntermediateResponseListener());
        r.setReferralDepth(this.getReferralDepth());
        r.setReferralConnector(this.getReferralConnectorInternal());
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_REGISTER_YUBIKEY_OTP_REQUEST_NAME.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("RegisterYubiKeyOTPDeviceExtendedRequest(");
        if (this.authenticationID != null) {
            buffer.append("authenticationID='");
            buffer.append(this.authenticationID);
            buffer.append("', ");
        }
        buffer.append("staticPasswordProvided=");
        buffer.append(this.staticPassword != null);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

