/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IndexSettingBlocks
implements PlainJsonSerializable {
    @Nullable
    private final Boolean readOnly;
    @Nullable
    private final Boolean readOnlyAllowDelete;
    @Nullable
    private final Boolean read;
    @Nullable
    private final Boolean write;
    @Nullable
    private final Boolean metadata;
    public static final JsonpDeserializer<IndexSettingBlocks> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingBlocks::setupIndexSettingBlocksDeserializer);

    private IndexSettingBlocks(Builder builder) {
        this.readOnly = builder.readOnly;
        this.readOnlyAllowDelete = builder.readOnlyAllowDelete;
        this.read = builder.read;
        this.write = builder.write;
        this.metadata = builder.metadata;
    }

    public static IndexSettingBlocks of(Function<Builder, ObjectBuilder<IndexSettingBlocks>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean readOnly() {
        return this.readOnly;
    }

    @Nullable
    public final Boolean readOnlyAllowDelete() {
        return this.readOnlyAllowDelete;
    }

    @Nullable
    public final Boolean read() {
        return this.read;
    }

    @Nullable
    public final Boolean write() {
        return this.write;
    }

    @Nullable
    public final Boolean metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.readOnly != null) {
            generator.writeKey("read_only");
            generator.write(this.readOnly.booleanValue());
        }
        if (this.readOnlyAllowDelete != null) {
            generator.writeKey("read_only_allow_delete");
            generator.write(this.readOnlyAllowDelete.booleanValue());
        }
        if (this.read != null) {
            generator.writeKey("read");
            generator.write(this.read.booleanValue());
        }
        if (this.write != null) {
            generator.writeKey("write");
            generator.write(this.write.booleanValue());
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.write(this.metadata.booleanValue());
        }
    }

    protected static void setupIndexSettingBlocksDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::readOnly, JsonpDeserializer.booleanDeserializer(), "read_only");
        op.add(Builder::readOnlyAllowDelete, JsonpDeserializer.booleanDeserializer(), "read_only_allow_delete");
        op.add(Builder::read, JsonpDeserializer.booleanDeserializer(), "read");
        op.add(Builder::write, JsonpDeserializer.booleanDeserializer(), "write");
        op.add(Builder::metadata, JsonpDeserializer.booleanDeserializer(), "metadata");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexSettingBlocks> {
        @Nullable
        private Boolean readOnly;
        @Nullable
        private Boolean readOnlyAllowDelete;
        @Nullable
        private Boolean read;
        @Nullable
        private Boolean write;
        @Nullable
        private Boolean metadata;

        public final Builder readOnly(@Nullable Boolean value) {
            this.readOnly = value;
            return this;
        }

        public final Builder readOnlyAllowDelete(@Nullable Boolean value) {
            this.readOnlyAllowDelete = value;
            return this;
        }

        public final Builder read(@Nullable Boolean value) {
            this.read = value;
            return this;
        }

        public final Builder write(@Nullable Boolean value) {
            this.write = value;
            return this;
        }

        public final Builder metadata(@Nullable Boolean value) {
            this.metadata = value;
            return this;
        }

        @Override
        public IndexSettingBlocks build() {
            this._checkSingleUse();
            return new IndexSettingBlocks(this);
        }
    }
}

