/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaScope;
import org.apache.james.core.quota.QuotaType;

public class QuotaLimit {
    private final QuotaComponent quotaComponent;
    private final QuotaScope quotaScope;
    private final String identifier;
    private final QuotaType quotaType;
    private final Optional<Long> quotaLimit;

    public static Builder builder() {
        return new Builder();
    }

    private QuotaLimit(QuotaComponent quotaComponent, QuotaScope quotaScope, String identifier, QuotaType quotaType, Long quotaLimit) {
        this.quotaComponent = quotaComponent;
        this.quotaScope = quotaScope;
        this.identifier = identifier;
        this.quotaType = quotaType;
        this.quotaLimit = Optional.ofNullable(quotaLimit);
    }

    public QuotaComponent getQuotaComponent() {
        return this.quotaComponent;
    }

    public QuotaScope getQuotaScope() {
        return this.quotaScope;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public QuotaType getQuotaType() {
        return this.quotaType;
    }

    public Optional<Long> getQuotaLimit() {
        return this.quotaLimit;
    }

    public final int hashCode() {
        return Objects.hash(this.quotaComponent, this.quotaScope, this.identifier, this.quotaType, this.quotaLimit);
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaLimit) {
            QuotaLimit other = (QuotaLimit)o;
            return Objects.equals(this.quotaComponent, other.quotaComponent) && Objects.equals(this.quotaScope, other.quotaScope) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.quotaType, other.quotaType) && Objects.equals(this.quotaLimit, other.quotaLimit);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("quotaComponent", this.quotaComponent).add("quotaScope", this.quotaScope).add("identifier", this.identifier).add("quotaType", this.quotaType).add("quotaLimit", this.quotaLimit).toString();
    }

    public static class Builder {
        private QuotaComponent quotaComponent;
        private QuotaScope quotaScope;
        private String identifier;
        private QuotaType quotaType;
        private Long quotaLimit;

        public Builder quotaComponent(QuotaComponent quotaComponent) {
            this.quotaComponent = quotaComponent;
            return this;
        }

        public Builder quotaScope(QuotaScope quotaScope) {
            this.quotaScope = quotaScope;
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder quotaType(QuotaType quotaType) {
            this.quotaType = quotaType;
            return this;
        }

        public Builder quotaLimit(Long quotaLimit) {
            this.quotaLimit = quotaLimit;
            return this;
        }

        public QuotaLimit build() {
            Preconditions.checkState(this.quotaComponent != null, "`quotaComponent` is mandatory");
            Preconditions.checkState(this.quotaScope != null, "`quotaScope` is mandatory");
            Preconditions.checkState(this.identifier != null, "`identifier` is mandatory");
            Preconditions.checkState(this.quotaType != null, "`quotaType` is mandatory");
            return new QuotaLimit(this.quotaComponent, this.quotaScope, this.identifier, this.quotaType, this.quotaLimit);
        }
    }
}

