/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.access;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.access.AccessToken;
import org.apache.james.jmap.api.access.AccessTokenRepository;
import org.apache.james.jmap.api.access.exceptions.InvalidAccessToken;
import org.apache.james.jmap.cassandra.access.CassandraAccessTokenDAO;
import reactor.core.publisher.Mono;

public class CassandraAccessTokenRepository
implements AccessTokenRepository {
    private final CassandraAccessTokenDAO cassandraAccessTokenDAO;

    @Inject
    CassandraAccessTokenRepository(CassandraAccessTokenDAO cassandraAccessTokenDAO) {
        this.cassandraAccessTokenDAO = cassandraAccessTokenDAO;
    }

    public Mono<Void> addToken(Username username, AccessToken accessToken) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull((Object)accessToken);
        return this.cassandraAccessTokenDAO.addToken(username, accessToken);
    }

    public Mono<Void> removeToken(AccessToken accessToken) {
        Preconditions.checkNotNull((Object)accessToken);
        return this.cassandraAccessTokenDAO.removeToken(accessToken);
    }

    public Mono<Username> getUsernameFromToken(AccessToken accessToken) throws InvalidAccessToken {
        Preconditions.checkNotNull((Object)accessToken);
        return this.cassandraAccessTokenDAO.getUsernameFromToken(accessToken).switchIfEmpty(Mono.error(() -> new InvalidAccessToken(accessToken)));
    }
}

