/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.map;

import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.config.map.MapBasedDriverExecutionProfile;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MapBasedDriverConfig
implements DriverConfig {
    private final Map<String, Map<DriverOption, Object>> optionsMap;
    private final Map<String, MapBasedDriverExecutionProfile> profiles = new ConcurrentHashMap<String, MapBasedDriverExecutionProfile>();

    public MapBasedDriverConfig(Map<String, Map<DriverOption, Object>> optionsMap) {
        this.optionsMap = optionsMap;
        if (!optionsMap.containsKey("default")) {
            throw new IllegalArgumentException("The options map must contain a profile named default");
        }
        this.createMissingProfiles();
    }

    @Override
    @NonNull
    public DriverExecutionProfile getProfile(@NonNull String profileName) {
        return this.profiles.computeIfAbsent(profileName, this::newProfile);
    }

    @Override
    @NonNull
    public Map<String, ? extends DriverExecutionProfile> getProfiles() {
        this.createMissingProfiles();
        return Collections.unmodifiableMap(this.profiles);
    }

    private void createMissingProfiles() {
        for (Map.Entry<String, Map<DriverOption, Object>> entry : this.optionsMap.entrySet()) {
            String profileName = entry.getKey();
            if (this.profiles.containsKey(profileName)) continue;
            this.profiles.put(profileName, this.newProfile(profileName));
        }
    }

    private MapBasedDriverExecutionProfile newProfile(String profileName) {
        return new MapBasedDriverExecutionProfile(this.optionsMap, profileName);
    }
}

