/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.addresstranslation;

import com.datastax.oss.driver.api.core.addresstranslation.AddressTranslator;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ec2MultiRegionAddressTranslator
implements AddressTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(Ec2MultiRegionAddressTranslator.class);
    private final DirContext ctx;
    private final String logPrefix;

    public Ec2MultiRegionAddressTranslator(@NonNull DriverContext context) {
        this.logPrefix = context.getSessionName();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            this.ctx = new InitialDirContext(env);
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not create translator", e);
        }
    }

    @VisibleForTesting
    Ec2MultiRegionAddressTranslator(@NonNull DirContext ctx) {
        this.logPrefix = "test";
        this.ctx = ctx;
    }

    @Override
    @NonNull
    public InetSocketAddress translate(@NonNull InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        try {
            String domainName = this.lookupPtrRecord(Ec2MultiRegionAddressTranslator.reverse(address));
            if (domainName == null) {
                LOG.warn("[{}] Found no domain name for {}, returning it as-is", (Object)this.logPrefix, (Object)address);
                return socketAddress;
            }
            InetAddress translatedAddress = InetAddress.getByName(domainName);
            LOG.debug("[{}] Resolved {} to {}", new Object[]{this.logPrefix, address, translatedAddress});
            return new InetSocketAddress(translatedAddress, socketAddress.getPort());
        }
        catch (Exception e) {
            Loggers.warnWithException(LOG, "[{}] Error resolving {}, returning it as-is", this.logPrefix, address, e);
            return socketAddress;
        }
    }

    private String lookupPtrRecord(String reversedDomain) throws Exception {
        Attributes attrs = this.ctx.getAttributes(reversedDomain, new String[]{"PTR"});
        NamingEnumeration<? extends Attribute> ae = attrs.getAll();
        while (ae.hasMoreElements()) {
            Attribute attr = ae.next();
            NamingEnumeration<?> vals = attr.getAll();
            if (!vals.hasMoreElements()) continue;
            return vals.nextElement().toString();
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.ctx.close();
        }
        catch (NamingException e) {
            Loggers.warnWithException(LOG, "Error closing translator", e);
        }
    }

    @VisibleForTesting
    static String reverse(InetAddress address) {
        byte[] bytes = address.getAddress();
        if (bytes.length == 4) {
            return Ec2MultiRegionAddressTranslator.reverseIpv4(bytes);
        }
        return Ec2MultiRegionAddressTranslator.reverseIpv6(bytes);
    }

    private static String reverseIpv4(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = bytes.length - 1; i >= 0; --i) {
            builder.append(bytes[i] & 0xFF).append('.');
        }
        builder.append("in-addr.arpa");
        return builder.toString();
    }

    private static String reverseIpv6(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = bytes.length - 1; i >= 0; --i) {
            byte b = bytes[i];
            int lowNibble = b & 0xF;
            int highNibble = b >> 4 & 0xF;
            builder.append(Integer.toHexString(lowNibble)).append('.').append(Integer.toHexString(highNibble)).append('.');
        }
        builder.append("ip6.arpa");
        return builder.toString();
    }
}

