/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.methods.SetMailboxesProcessor;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.SetMailboxesRequest;
import org.apache.james.jmap.draft.model.SetMailboxesResponse;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class SetMailboxesMethod
implements Method {
    private static final Method.Request.Name METHOD_NAME = Method.Request.name("setMailboxes");
    @VisibleForTesting
    static final Method.Response.Name RESPONSE_NAME = Method.Response.name("mailboxesSet");
    private final Set<SetMailboxesProcessor> processors;
    private final MetricFactory metricFactory;

    @Inject
    public SetMailboxesMethod(Set<SetMailboxesProcessor> processors, MetricFactory metricFactory) {
        this.processors = processors;
        this.metricFactory = metricFactory;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return SetMailboxesRequest.class;
    }

    @Override
    public Flux<JmapResponse> process(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)methodCallId);
        Preconditions.checkNotNull((Object)mailboxSession);
        Preconditions.checkArgument((boolean)(request instanceof SetMailboxesRequest));
        SetMailboxesRequest setMailboxesRequest = (SetMailboxesRequest)request;
        return Flux.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-" + METHOD_NAME.getName(), (Publisher)this.setMailboxesResponse(setMailboxesRequest, mailboxSession).map(response -> JmapResponse.builder().methodCallId(methodCallId).response((Method.Response)response).responseName(RESPONSE_NAME).build()))).contextWrite((ContextView)ReactorUtils.context((String)"action", (MDCBuilder)this.mdc(setMailboxesRequest)));
    }

    private MDCBuilder mdc(SetMailboxesRequest setMailboxesRequest) {
        return MDCBuilder.create().addToContext("action", "SET_MAILBOXES").addToContext("create", setMailboxesRequest.getCreate().toString()).addToContext("update", setMailboxesRequest.getUpdate().toString()).addToContext("destroy", setMailboxesRequest.getDestroy().toString());
    }

    private Mono<SetMailboxesResponse> setMailboxesResponse(SetMailboxesRequest request, MailboxSession mailboxSession) {
        return Flux.fromIterable(this.processors).flatMap(processor -> processor.processReactive(request, mailboxSession)).reduce((Object)SetMailboxesResponse.builder(), (builder, resp) -> resp.mergeInto((SetMailboxesResponse.Builder)builder)).map(SetMailboxesResponse.Builder::build);
    }
}

