/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mu;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.apache.james.mu.MailReportEntry;
import org.apache.james.mu.MailReportGenerator;
import org.apache.james.util.DurationParser;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import spark.ResponseTransformer;
import spark.Service;

public class MuReportsRoute
implements Routes {
    private final MailReportGenerator receivedMailReportGenerator;
    private final Clock clock;

    @Inject
    public MuReportsRoute(MailReportGenerator receivedMailReportGenerator, Clock clock) {
        this.receivedMailReportGenerator = receivedMailReportGenerator;
        this.clock = clock;
    }

    public String getBasePath() {
        return "/mu/reports";
    }

    public void define(Service service) {
        service.get(this.getBasePath() + "/mails", (request, response) -> {
            String rawDuration = request.queryParams("duration");
            Preconditions.checkArgument((rawDuration != null ? 1 : 0) != 0, (Object)"'duration' is a mandatory parameter");
            Duration duration = DurationParser.parse((String)rawDuration);
            Instant now = this.clock.instant();
            Instant reportStart = now.minus(duration);
            return this.receivedMailReportGenerator.generateReport(reportStart, now).map(MailReportEntryDAO::from).collectList().block();
        }, (ResponseTransformer)new JsonTransformer(new JsonTransformerModule[0]));
    }

    public record MailReportEntryDAO(MailReportEntry.Kind kind, String subject, String sender, String recipient, Instant date) {
        public static MailReportEntryDAO from(MailReportEntry entry) {
            return new MailReportEntryDAO(entry.kind(), entry.subject(), entry.sender().asString("<>"), entry.recipient().asString(), entry.date());
        }
    }
}

