/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.FunctionScore;
import org.opensearch.client.opensearch._types.query_dsl.FunctionScoreVariant;
import org.opensearch.client.opensearch._types.query_dsl.ScoreFunctionBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class RandomScoreFunction
extends ScoreFunctionBase
implements FunctionScoreVariant {
    @Nullable
    private final String field;
    @Nullable
    private final String seed;
    public static final JsonpDeserializer<RandomScoreFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RandomScoreFunction::setupRandomScoreFunctionDeserializer);

    private RandomScoreFunction(Builder builder) {
        super(builder);
        this.field = builder.field;
        this.seed = builder.seed;
    }

    public static RandomScoreFunction of(Function<Builder, ObjectBuilder<RandomScoreFunction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FunctionScore.Kind _functionScoreKind() {
        return FunctionScore.Kind.RandomScore;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String seed() {
        return this.seed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.seed != null) {
            generator.writeKey("seed");
            generator.write(this.seed);
        }
    }

    protected static void setupRandomScoreFunctionDeserializer(ObjectDeserializer<Builder> op) {
        RandomScoreFunction.setupScoreFunctionBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::seed, JsonpDeserializer.stringDeserializer(), "seed");
    }

    public static class Builder
    extends ScoreFunctionBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RandomScoreFunction> {
        @Nullable
        private String field;
        @Nullable
        private String seed;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder seed(@Nullable String value) {
            this.seed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RandomScoreFunction build() {
            this._checkSingleUse();
            return new RandomScoreFunction(this);
        }
    }
}

