/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.james.json.DTOConverter;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.task.Hostname;
import org.apache.james.task.TaskExecutionDetails;

public class ExecutionDetailsDto {
    private final TaskExecutionDetails executionDetails;
    private final Optional<AdditionalInformationDTO> additionalInformation;

    public static List<ExecutionDetailsDto> from(DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO> additionalInformationConverter, Stream<TaskExecutionDetails> tasksDetails) {
        return (List)tasksDetails.map(details -> ExecutionDetailsDto.from(additionalInformationConverter, details)).collect(ImmutableList.toImmutableList());
    }

    public static ExecutionDetailsDto from(DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO> additionalInformationConverter, TaskExecutionDetails taskDetails) {
        return new ExecutionDetailsDto(taskDetails, taskDetails.getAdditionalInformation().flatMap(arg_0 -> additionalInformationConverter.toDTO(arg_0)));
    }

    private ExecutionDetailsDto(TaskExecutionDetails executionDetails, Optional<AdditionalInformationDTO> additionalInformation) {
        this.executionDetails = executionDetails;
        this.additionalInformation = additionalInformation;
    }

    public UUID getTaskId() {
        return this.executionDetails.getTaskId().getValue();
    }

    public String getType() {
        return this.executionDetails.getType().asString();
    }

    public String getStatus() {
        return this.executionDetails.getStatus().getValue();
    }

    public String getSubmittedFrom() {
        return this.executionDetails.getSubmittedNode().asString();
    }

    public Optional<String> getExecutedOn() {
        return this.executionDetails.getRanNode().map(Hostname::asString);
    }

    public Optional<String> getCancelledFrom() {
        return this.executionDetails.getCancelRequestedNode().map(Hostname::asString);
    }

    public Optional<AdditionalInformationDTO> getAdditionalInformation() {
        return this.additionalInformation;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public ZonedDateTime getSubmitDate() {
        return this.executionDetails.getSubmittedDate();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public Optional<ZonedDateTime> getStartedDate() {
        return this.executionDetails.getStartedDate();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public Optional<ZonedDateTime> getCompletedDate() {
        return this.executionDetails.getCompletedDate();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public Optional<ZonedDateTime> getCanceledDate() {
        return this.executionDetails.getCanceledDate();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public Optional<ZonedDateTime> getFailedDate() {
        return this.executionDetails.getFailedDate();
    }
}

