/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.indexer;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxId;

public class ReIndexingExecutionFailures {
    private final List<ReIndexingFailure> messageFailures;
    private final List<MailboxId> mailboxFailures;

    public ReIndexingExecutionFailures(List<ReIndexingFailure> messageFailures, List<MailboxId> mailboxFailures) {
        this.messageFailures = messageFailures;
        this.mailboxFailures = mailboxFailures;
    }

    public List<ReIndexingFailure> messageFailures() {
        return ImmutableList.copyOf(this.messageFailures);
    }

    public List<MailboxId> mailboxFailures() {
        return ImmutableList.copyOf(this.mailboxFailures);
    }

    public final boolean equals(Object o) {
        if (o instanceof ReIndexingExecutionFailures) {
            ReIndexingExecutionFailures that = (ReIndexingExecutionFailures)o;
            return Objects.equals(this.messageFailures, that.messageFailures) && Objects.equals(this.mailboxFailures, that.mailboxFailures);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.messageFailures, this.mailboxFailures);
    }

    public static class ReIndexingFailure {
        private final MailboxId mailboxId;
        private final MessageUid uid;

        public ReIndexingFailure(MailboxId mailboxId, MessageUid uid) {
            this.mailboxId = mailboxId;
            this.uid = uid;
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }

        public MessageUid getUid() {
            return this.uid;
        }

        public final boolean equals(Object o) {
            if (o instanceof ReIndexingFailure) {
                ReIndexingFailure that = (ReIndexingFailure)o;
                return Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.uid, that.uid);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.mailboxId, this.uid);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mailboxId", (Object)this.mailboxId).add("uid", (Object)this.uid).toString();
        }
    }
}

