/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.MessageAttachmentRepresentation;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIds;
import org.apache.james.mailbox.cassandra.table.CassandraMessageV2Table;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class CassandraMessageDAO {
    public static final long DEFAULT_LONG_VALUE = 0L;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final CassandraTypesProvider typesProvider;
    private final BlobStore blobStore;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement insert;
    private final PreparedStatement delete;
    private final PreparedStatement select;
    private final PreparedStatement selectAll;
    private final Cid.CidParser cidParser;

    @Inject
    public CassandraMessageDAO(CqlSession session, CassandraTypesProvider typesProvider, BlobStore blobStore, BlobId.Factory blobIdFactory) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.typesProvider = typesProvider;
        this.blobStore = blobStore;
        this.blobIdFactory = blobIdFactory;
        this.insert = this.prepareInsert(session);
        this.delete = this.prepareDelete(session);
        this.select = this.prepareSelect(session);
        this.selectAll = this.prepareSelectAll(session);
        this.cidParser = Cid.parser().relaxed();
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"messageV2").all().where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)))).build());
    }

    private PreparedStatement prepareSelectAll(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"messageV2").all().build());
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"messageV2").value(CassandraMessageIds.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)).value(CassandraMessageV2Table.INTERNAL_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV2Table.INTERNAL_DATE)).value(CassandraMessageV2Table.BODY_START_OCTET, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV2Table.BODY_START_OCTET)).value(CassandraMessageV2Table.FULL_CONTENT_OCTETS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV2Table.FULL_CONTENT_OCTETS)).value(CassandraMessageV2Table.BODY_OCTECTS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV2Table.BODY_OCTECTS)).value(CassandraMessageV2Table.BODY_CONTENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV2Table.BODY_CONTENT)).value(CassandraMessageV2Table.HEADER_CONTENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV2Table.HEADER_CONTENT)).value(CassandraMessageV2Table.PROPERTIES, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV2Table.PROPERTIES)).value(CassandraMessageV2Table.TEXTUAL_LINE_COUNT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV2Table.TEXTUAL_LINE_COUNT)).value(CassandraMessageV2Table.ATTACHMENTS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV2Table.ATTACHMENTS)).build());
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"messageV2").where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)))).build());
    }

    public Flux<MessageRepresentation> list() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectAll.bind(new Object[0])).map(this::message);
    }

    public Mono<Void> save(MailboxMessage message) throws MailboxException {
        return this.saveContent(message).flatMap(pair -> this.cassandraAsyncExecutor.executeVoid((Statement)this.boundWriteStatement(message, (Tuple2<BlobId, BlobId>)pair)));
    }

    private Mono<Tuple2<BlobId, BlobId>> saveContent(final MailboxMessage message) throws MailboxException {
        try {
            byte[] headerContent = IOUtils.toByteArray((InputStream)message.getHeaderContent());
            ByteSource bodyByteSource = new ByteSource(){

                public InputStream openStream() {
                    try {
                        return message.getBodyContent();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public long size() {
                    return message.getBodyOctets();
                }
            };
            Mono headerFuture = Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), headerContent, BlobStore.StoragePolicy.SIZE_BASED));
            Mono bodyFuture = Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), bodyByteSource, BlobStore.StoragePolicy.LOW_COST));
            return headerFuture.zipWith(bodyFuture);
        }
        catch (IOException e) {
            throw new MailboxException("Error saving mail content", (Throwable)e);
        }
    }

    private BoundStatement boundWriteStatement(MailboxMessage message, Tuple2<BlobId, BlobId> pair) {
        CassandraMessageId messageId = (CassandraMessageId)message.getMessageId();
        return (BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insert.bind(new Object[0]).setUuid(CassandraMessageIds.MESSAGE_ID, messageId.get())).setInstant(CassandraMessageV2Table.INTERNAL_DATE, message.getInternalDate().toInstant())).setInt(CassandraMessageV2Table.BODY_START_OCTET, (int)message.getHeaderOctets())).setLong(CassandraMessageV2Table.FULL_CONTENT_OCTETS, message.getFullContentOctets())).setLong(CassandraMessageV2Table.BODY_OCTECTS, message.getBodyOctets())).setString(CassandraMessageV2Table.BODY_CONTENT, ((BlobId)pair.getT2()).asString())).setString(CassandraMessageV2Table.HEADER_CONTENT, ((BlobId)pair.getT1()).asString())).setLong(CassandraMessageV2Table.TEXTUAL_LINE_COUNT, Optional.ofNullable(message.getTextualLineCount()).orElse(0L).longValue())).setList(CassandraMessageV2Table.PROPERTIES, this.buildPropertiesUdt(message), UdtValue.class)).setList(CassandraMessageV2Table.ATTACHMENTS, this.buildAttachmentUdt(message), UdtValue.class);
    }

    private ImmutableList<UdtValue> buildAttachmentUdt(MailboxMessage message) {
        return (ImmutableList)message.getAttachments().stream().map(this::toUDT).collect(ImmutableList.toImmutableList());
    }

    private UdtValue toUDT(MessageAttachmentMetadata messageAttachment) {
        UdtValue result = (UdtValue)((UdtValue)this.typesProvider.getDefinedUserType(CassandraMessageV2Table.ATTACHMENTS.asCql(true)).newValue().setString(CassandraMessageV2Table.Attachments.ID, messageAttachment.getAttachmentId().getId())).setBoolean(CassandraMessageV2Table.Attachments.IS_INLINE, messageAttachment.isInline());
        Optional<UdtValue> maybeSetAttachmentsName = messageAttachment.getName().map(name -> (UdtValue)result.setString(CassandraMessageV2Table.Attachments.NAME, name));
        Optional<UdtValue> maybeSetAttachmentsCId = maybeSetAttachmentsName.map(udtValue -> messageAttachment.getCid().map(cid -> (UdtValue)udtValue.setString(CassandraMessageV2Table.Attachments.CID, cid.getValue())).orElse((UdtValue)udtValue));
        return maybeSetAttachmentsCId.orElse(result);
    }

    private List<UdtValue> buildPropertiesUdt(MailboxMessage message) {
        return (List)message.getProperties().toProperties().stream().map(property -> (UdtValue)((UdtValue)((UdtValue)this.typesProvider.getDefinedUserType(CassandraMessageV2Table.PROPERTIES.asCql(true)).newValue().setString(CassandraMessageV2Table.Properties.NAMESPACE, property.getNamespace())).setString(CassandraMessageV2Table.Properties.NAME, property.getLocalName())).setString(CassandraMessageV2Table.Properties.VALUE, property.getValue())).collect(ImmutableList.toImmutableList());
    }

    public Mono<MessageRepresentation> retrieveMessage(ComposedMessageIdWithMetaData id, MessageMapper.FetchType fetchType) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)id.getComposedMessageId().getMessageId();
        return this.retrieveMessage(cassandraMessageId, fetchType);
    }

    public Mono<MessageRepresentation> retrieveMessage(CassandraMessageId cassandraMessageId, MessageMapper.FetchType fetchType) {
        return this.retrieveRow(cassandraMessageId).flatMap(resultSet -> this.message((Row)resultSet, cassandraMessageId, fetchType));
    }

    private Mono<Row> retrieveRow(CassandraMessageId messageId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.select.bind(new Object[0]).setUuid(CassandraMessageIds.MESSAGE_ID, messageId.get()));
    }

    private Mono<MessageRepresentation> message(Row row, CassandraMessageId cassandraMessageId, MessageMapper.FetchType fetchType) {
        BlobId headerId = this.retrieveBlobId(CassandraMessageV2Table.HEADER_CONTENT, row);
        BlobId bodyId = this.retrieveBlobId(CassandraMessageV2Table.BODY_CONTENT, row);
        return this.buildContentRetriever(fetchType, headerId, bodyId).map(content -> new MessageRepresentation(cassandraMessageId, Optional.ofNullable(row.getInstant(CassandraMessageV2Table.INTERNAL_DATE)).map(Date::from).orElse(null), row.getLong(CassandraMessageV2Table.FULL_CONTENT_OCTETS), row.getInt(CassandraMessageV2Table.BODY_START_OCTET), (Content)new ByteContent(content), this.getProperties(row), (List)this.getAttachments(row).collect(ImmutableList.toImmutableList()), headerId, bodyId));
    }

    private MessageRepresentation message(Row row) {
        BlobId headerId = this.retrieveBlobId(CassandraMessageV2Table.HEADER_CONTENT, row);
        BlobId bodyId = this.retrieveBlobId(CassandraMessageV2Table.BODY_CONTENT, row);
        CassandraMessageId messageId = CassandraMessageId.Factory.of(row.getUuid(CassandraMessageIds.MESSAGE_ID));
        return new MessageRepresentation(messageId, Optional.ofNullable(row.getInstant(CassandraMessageV2Table.INTERNAL_DATE)).map(Date::from).orElse(null), row.getLong(CassandraMessageV2Table.FULL_CONTENT_OCTETS), row.getInt(CassandraMessageV2Table.BODY_START_OCTET), (Content)new ByteContent(EMPTY_BYTE_ARRAY), this.getProperties(row), (List)this.getAttachments(row).collect(ImmutableList.toImmutableList()), headerId, bodyId);
    }

    private Properties getProperties(Row row) {
        PropertyBuilder property = new PropertyBuilder(Optional.ofNullable(row.getList(CassandraMessageV2Table.PROPERTIES, UdtValue.class)).map(list -> list.stream().map(this::toProperty).collect(Collectors.toList())).orElse(List.of()));
        property.setTextualLineCount(Long.valueOf(row.getLong(CassandraMessageV2Table.TEXTUAL_LINE_COUNT)));
        return property.build();
    }

    private Property toProperty(UdtValue udtValue) {
        return new Property(udtValue.getString(CassandraMessageV2Table.Properties.NAMESPACE), udtValue.getString(CassandraMessageV2Table.Properties.NAME), udtValue.getString(CassandraMessageV2Table.Properties.VALUE));
    }

    private Stream<MessageAttachmentRepresentation> getAttachments(Row row) {
        List<UdtValue> udtValues = Optional.ofNullable(row.getList(CassandraMessageV2Table.ATTACHMENTS, UdtValue.class)).orElse(List.of());
        return this.attachmentByIds(udtValues);
    }

    private Stream<MessageAttachmentRepresentation> attachmentByIds(List<UdtValue> udtValues) {
        return udtValues.stream().map(this::messageAttachmentByIdFrom);
    }

    private MessageAttachmentRepresentation messageAttachmentByIdFrom(UdtValue udtValue) {
        return MessageAttachmentRepresentation.builder().attachmentId(AttachmentId.from((String)udtValue.getString(CassandraMessageV2Table.Attachments.ID))).name(udtValue.getString(CassandraMessageV2Table.Attachments.NAME)).cid(this.cidParser.parse(udtValue.getString(CassandraMessageV2Table.Attachments.CID))).isInline(udtValue.getBoolean(CassandraMessageV2Table.Attachments.IS_INLINE)).build();
    }

    public Mono<Void> delete(CassandraMessageId messageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind(new Object[0]).setUuid(CassandraMessageIds.MESSAGE_ID, messageId.get()));
    }

    private Mono<byte[]> buildContentRetriever(MessageMapper.FetchType fetchType, BlobId headerId, BlobId bodyId) {
        switch (fetchType) {
            case FULL: {
                return this.getFullContent(headerId, bodyId);
            }
            case ATTACHMENTS_METADATA: 
            case HEADERS: {
                return this.getContent(headerId, BlobStore.StoragePolicy.SIZE_BASED);
            }
            case METADATA: {
                return Mono.just((Object)EMPTY_BYTE_ARRAY);
            }
        }
        throw new RuntimeException("Unknown FetchType " + fetchType);
    }

    private Mono<byte[]> getFullContent(BlobId headerId, BlobId bodyId) {
        return this.getContent(headerId, BlobStore.StoragePolicy.SIZE_BASED).zipWith(this.getContent(bodyId, BlobStore.StoragePolicy.LOW_COST), (xva$0, xva$1) -> Bytes.concat((byte[][])new byte[][]{xva$0, xva$1}));
    }

    private Mono<byte[]> getContent(BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return Mono.from((Publisher)this.blobStore.readBytes(this.blobStore.getDefaultBucketName(), blobId, storagePolicy));
    }

    private BlobId retrieveBlobId(CqlIdentifier field, Row row) {
        return this.blobIdFactory.from(row.getString(field));
    }
}

