/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import java.util.List;
import java.util.Optional;
import org.apache.james.protocols.api.ProtocolConfiguration;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolSessionImpl;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;

public class SMTPSessionImpl
extends ProtocolSessionImpl
implements SMTPSession {
    private static final Response LINE_LENGTH_EXCEEDED = new SMTPResponse("500", "Line length exceeded. See RFC 2821 #4.5.3.1.").immutable();
    private static final Response FATAL_ERROR = new SMTPResponse("451", "Unable to process request").immutable();
    private static final Response UNKNOWN_COMMAND_ERROR = new SMTPResponse("500", "Unable to process request: the command is unknown").immutable();
    private long currentMessageSize = 0L;
    private boolean relayingAllowed;
    private boolean headerComplete = false;
    private boolean messageFailed = false;

    public SMTPSessionImpl(ProtocolTransport transport, SMTPConfiguration config) {
        super(transport, (ProtocolConfiguration)config);
        this.relayingAllowed = config.isRelayingAllowed(this.getRemoteAddress().getAddress().getHostAddress());
    }

    @Override
    public boolean isRelayingAllowed() {
        return this.relayingAllowed;
    }

    public void resetState() {
        Optional currentHeloMode = this.getAttachment(CURRENT_HELO_MODE, ProtocolSession.State.Connection);
        this.getState().clear();
        currentHeloMode.ifPresent(heloMode -> this.setAttachment(CURRENT_HELO_MODE, heloMode, ProtocolSession.State.Connection));
        this.currentMessageSize = 0L;
        this.headerComplete = false;
        this.messageFailed = false;
    }

    @Override
    public int getRcptCount() {
        return this.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).map(List::size).orElse(0);
    }

    @Override
    public boolean supportsOAuth() {
        return this.getConfiguration().saslConfiguration().isPresent() && this.isAuthAnnounced();
    }

    @Override
    public boolean isAuthAnnounced() {
        return this.getConfiguration().isAuthAnnounced(this.getRemoteAddress().getAddress().getHostAddress(), this.isTLSStarted());
    }

    @Override
    public void setRelayingAllowed(boolean relayingAllowed) {
        this.relayingAllowed = relayingAllowed;
    }

    public Response newLineTooLongResponse() {
        return LINE_LENGTH_EXCEEDED;
    }

    public Response newFatalErrorResponse() {
        return FATAL_ERROR;
    }

    public Response newCommandNotFoundErrorResponse() {
        return UNKNOWN_COMMAND_ERROR;
    }

    @Override
    public SMTPConfiguration getConfiguration() {
        return (SMTPConfiguration)this.config;
    }

    @Override
    public long currentMessageSize() {
        return this.currentMessageSize;
    }

    @Override
    public void setCurrentMessageSize(long newSize) {
        this.currentMessageSize = newSize;
    }

    @Override
    public boolean headerComplete() {
        return this.headerComplete;
    }

    @Override
    public void setHeaderComplete(boolean value) {
        this.headerComplete = value;
    }

    @Override
    public boolean messageFailed() {
        return this.messageFailed;
    }

    @Override
    public void setMessageFailed(boolean value) {
        this.messageFailed = value;
    }
}

