/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.queue.rabbitmq;

import com.google.inject.Module;
import java.io.FileNotFoundException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.modules.queue.rabbitmq.CassandraMailQueueViewModule;
import org.apache.james.modules.queue.rabbitmq.FakeMailQueueViewModule;
import org.apache.james.utils.PropertiesProvider;

public enum MailQueueViewChoice {
    CASSANDRA,
    NONE;


    public static MailQueueViewChoice parse(Configuration configuration) {
        if (configuration.getBoolean("cassandra.view.enabled", true)) {
            return CASSANDRA;
        }
        return NONE;
    }

    public static MailQueueViewChoice parse(PropertiesProvider configuration) {
        try {
            return MailQueueViewChoice.parse(configuration.getConfiguration("rabbitmq"));
        }
        catch (FileNotFoundException e) {
            return CASSANDRA;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ModuleChooser {
        public static Module choose(MailQueueViewChoice choice) {
            switch (choice) {
                case CASSANDRA: {
                    return new CassandraMailQueueViewModule();
                }
                case NONE: {
                    return new FakeMailQueueViewModule();
                }
            }
            throw new NotImplementedException();
        }
    }
}

