/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.projections;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.james.jmap.api.model.Preview;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageResult;

public class MessageFastViewPrecomputedProperties {
    private final Preview preview;
    private final boolean hasAttachment;

    public static Builder.RequirePreview builder() {
        return preview -> hasAttachment -> new Builder.FinalStage(preview, hasAttachment);
    }

    private MessageFastViewPrecomputedProperties(Preview preview, boolean hasAttachment) {
        this.preview = preview;
        this.hasAttachment = hasAttachment;
    }

    public Preview getPreview() {
        return this.preview;
    }

    public boolean hasAttachment() {
        return this.hasAttachment;
    }

    public final boolean equals(Object o) {
        if (o instanceof MessageFastViewPrecomputedProperties) {
            MessageFastViewPrecomputedProperties that = (MessageFastViewPrecomputedProperties)o;
            return Objects.equals(this.preview, that.preview) && Objects.equals(this.hasAttachment, that.hasAttachment);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.preview, this.hasAttachment);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("preview", (Object)this.preview).add("hasAttachment", this.hasAttachment).toString();
    }

    public static class Builder {

        public static class FinalStage {
            private final Preview preview;
            private final boolean hasAttachment;

            private FinalStage(Preview preview, boolean hasAttachment) {
                this.hasAttachment = hasAttachment;
                Preconditions.checkNotNull((Object)preview, (Object)"'preview' cannot be null");
                this.preview = preview;
            }

            public MessageFastViewPrecomputedProperties build() {
                return new MessageFastViewPrecomputedProperties(this.preview, this.hasAttachment);
            }
        }

        @FunctionalInterface
        public static interface RequireHasAttachment {
            public FinalStage hasAttachment(boolean var1);

            default public FinalStage hasAttachment() {
                return this.hasAttachment(true);
            }

            default public FinalStage noAttachments() {
                return this.hasAttachment(false);
            }
        }

        @FunctionalInterface
        public static interface RequirePreview {
            public RequireHasAttachment preview(Preview var1);
        }
    }

    public static class Factory {
        private final Preview.Factory previewFactory;

        @Inject
        public Factory(Preview.Factory previewFactory) {
            this.previewFactory = previewFactory;
        }

        public MessageFastViewPrecomputedProperties from(MessageResult messageResult) throws MailboxException, IOException {
            return MessageFastViewPrecomputedProperties.builder().preview(this.previewFactory.fromMessageResult(messageResult)).hasAttachment(this.hasAttachment(messageResult.getLoadedAttachments())).build();
        }

        private boolean hasAttachment(List<MessageAttachmentMetadata> attachments) {
            return attachments.stream().anyMatch(Predicate.not(MessageAttachmentMetadata::isInlinedWithCid));
        }
    }
}

