/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import org.apache.james.core.Domain;
import org.apache.james.rrt.lib.MappingSource;

public class RecipientRewriteTableUtil {
    private RecipientRewriteTableUtil() {
    }

    public static String getTargetString(String user, Domain domain, Map<MappingSource, String> mappings) {
        return Optional.ofNullable(mappings.get(MappingSource.fromUser((String)user, (Domain)domain))).or(() -> Optional.ofNullable((String)mappings.get(MappingSource.fromDomain((Domain)domain)))).orElse(null);
    }

    public static Map<MappingSource, String> getXMLMappings(String mapping) {
        HashMap<MappingSource, String> mappings = new HashMap<MappingSource, String>();
        StringTokenizer tokenizer = new StringTokenizer(mapping, ",");
        while (tokenizer.hasMoreTokens()) {
            String mappingItem = tokenizer.nextToken();
            int index = mappingItem.indexOf(61);
            String virtual = mappingItem.substring(0, index).trim().toLowerCase(Locale.US);
            String real = mappingItem.substring(index + 1).trim().toLowerCase(Locale.US);
            mappings.put(MappingSource.parse((String)virtual), real);
        }
        return mappings;
    }
}

