/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.StoreRequest;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.NullableMessageSequenceNumber;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class StoreProcessor
extends AbstractMailboxProcessor<StoreRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreProcessor.class);

    @Inject
    public StoreProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(StoreRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(StoreRequest request, ImapSession session, ImapProcessor.Responder responder) {
        boolean omitExpunged;
        IdRange[] idSet = request.getIdSet();
        ArrayList failed = new ArrayList();
        ArrayList failedMsns = new ArrayList();
        Flags flags = request.getFlags();
        List<String> userFlags = Arrays.asList(flags.getUserFlags());
        boolean bl = omitExpunged = !request.isUseUids();
        if (this.rejectUnchangedSinceZeroWithSystemFlagUpdate(request, responder, idSet, flags)) {
            return Mono.empty();
        }
        SelectedMailbox selected = session.getSelected();
        MailboxSession mailboxSession = session.getMailboxSession();
        return this.getSelectedMailboxReactive(session).flatMap(mailbox -> Flux.fromIterable((Iterable)ImmutableList.copyOf((Object[])idSet)).map(Throwing.function(idRange -> this.messageRange(selected, (IdRange)idRange, request.isUseUids())).sneakyThrow()).concatMap(messageSet -> this.handleRange(request, session, responder, selected, (MessageManager)mailbox, mailboxSession, failed, failedMsns, userFlags, (MessageRange)messageSet)).then()).then(this.unsolicitedResponses(session, responder, omitExpunged, request.isUseUids())).doOnSuccess(any -> {
            if (failed.isEmpty() && failedMsns.isEmpty()) {
                this.okComplete(request, responder);
            } else {
                this.respondFailed(request, responder, failed, failedMsns);
            }
        }).onErrorResume(MessageRangeException.class, e -> {
            this.taggedBad(request, responder, HumanReadableText.INVALID_MESSAGESET);
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Store failed for mailbox {} because of an invalid sequence-set {}", new Object[]{session.getSelected().getMailboxId(), idSet, e}));
        }).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.SAVE_FAILED);
            return ReactorUtils.logAsMono(() -> LOGGER.error("Store failed for mailbox {} and sequence-set {}", new Object[]{session.getSelected().getMailboxId(), idSet, e}));
        });
    }

    private Mono<Void> handleRange(StoreRequest request, ImapSession session, ImapProcessor.Responder responder, SelectedMailbox selected, MessageManager mailbox, MailboxSession mailboxSession, List<MessageUid> failed, List<NullableMessageSequenceNumber> failedMsns, List<String> userFlags, MessageRange messageSet) {
        if (messageSet != null) {
            if (request.getUnchangedSince() != -1L) {
                return Flux.from((Publisher)mailbox.listMessagesMetadata(messageSet, mailboxSession)).handle((id, sink) -> this.filterIfFailed(request, selected, failed, failedMsns, userFlags, (ComposedMessageIdWithMetaData)id).ifPresent(arg_0 -> ((SynchronousSink)sink).next(arg_0))).collectList().flatMapIterable(MessageRange::toRanges).concatMap(range -> this.setFlags(request, mailboxSession, mailbox, (MessageRange)range, session, responder)).then();
            }
            return this.setFlags(request, mailboxSession, mailbox, messageSet, session, responder);
        }
        return Mono.empty();
    }

    private Optional<MessageUid> filterIfFailed(StoreRequest request, SelectedMailbox selected, List<MessageUid> failed, List<NullableMessageSequenceNumber> failedMsns, List<String> userFlags, ComposedMessageIdWithMetaData r) {
        MessageUid uid = r.getComposedMessageId().getUid();
        boolean fail = false;
        if (request.getUnchangedSince() == 0L) {
            String[] uFlags;
            for (String uFlag : uFlags = r.getFlags().getUserFlags()) {
                if (!userFlags.contains(uFlag)) continue;
                fail = true;
                break;
            }
        }
        if (!fail && r.getModSeq().asLong() <= request.getUnchangedSince()) {
            return Optional.of(uid);
        }
        if (request.isUseUids()) {
            failed.add(uid);
        } else {
            failedMsns.add(selected.msn(uid));
        }
        return Optional.empty();
    }

    private boolean rejectUnchangedSinceZeroWithSystemFlagUpdate(StoreRequest request, ImapProcessor.Responder responder, IdRange[] idSet, Flags flags) {
        Flags.Flag[] systemFlags;
        if (request.getUnchangedSince() == 0L && (systemFlags = flags.getSystemFlags()) != null && systemFlags.length != 0) {
            StatusResponse response = this.getStatusResponseFactory().taggedOk(request.getTag(), request.getCommand(), HumanReadableText.FAILED, StatusResponse.ResponseCode.condStore(idSet));
            responder.respond(response);
            return true;
        }
        return false;
    }

    private void respondFailed(StoreRequest request, ImapProcessor.Responder responder, List<MessageUid> failed, List<NullableMessageSequenceNumber> failedMsns) {
        if (request.isUseUids()) {
            UidRange[] idRanges = (UidRange[])MessageRange.toRanges(failed).stream().map(r -> new UidRange(r.getUidFrom(), r.getUidTo())).toArray(UidRange[]::new);
            StatusResponse response = this.getStatusResponseFactory().taggedOk(request.getTag(), request.getCommand(), HumanReadableText.FAILED, StatusResponse.ResponseCode.condStore(idRanges));
            responder.respond(response);
        } else {
            ArrayList<IdRange> ranges = new ArrayList<IdRange>();
            for (NullableMessageSequenceNumber msn : failedMsns) {
                msn.ifPresent(id -> ranges.add(new IdRange(id.asInt())));
            }
            IdRange[] failedRanges = (IdRange[])IdRange.mergeRanges(ranges).toArray(IdRange[]::new);
            StatusResponse response = this.getStatusResponseFactory().taggedOk(request.getTag(), request.getCommand(), HumanReadableText.FAILED, StatusResponse.ResponseCode.condStore(failedRanges));
            responder.respond(response);
        }
    }

    private Mono<Void> setFlags(StoreRequest request, MailboxSession mailboxSession, MessageManager mailbox, MessageRange messageSet, ImapSession session, ImapProcessor.Responder responder) {
        boolean silent = request.isSilent();
        long unchangedSince = request.getUnchangedSince();
        SelectedMailbox selected = session.getSelected();
        return Mono.from((Publisher)mailbox.setFlagsReactive(request.getFlags(), request.getFlagsUpdateMode(), messageSet, mailboxSession)).doOnNext(flagsByUid -> this.handlePermanentFlagChanges(mailboxSession, mailbox, responder, selected)).flatMap(flagsByUid -> this.handleCondstore(request, mailboxSession, mailbox, messageSet, session, responder, silent, unchangedSince, selected, (Map<MessageUid, Flags>)flagsByUid));
    }

    private Mono<Void> handleCondstore(StoreRequest request, MailboxSession mailboxSession, MessageManager mailbox, MessageRange messageSet, ImapSession session, ImapProcessor.Responder responder, boolean silent, long unchangedSince, SelectedMailbox selected, Map<MessageUid, Flags> flagsByUid) {
        Set<Capability> enabled = EnableProcessor.getEnabledCapabilities(session);
        boolean qresyncEnabled = enabled.contains(ImapConstants.SUPPORTS_QRESYNC);
        boolean condstoreEnabled = enabled.contains(ImapConstants.SUPPORTS_CONDSTORE);
        if (!silent || unchangedSince != -1L || qresyncEnabled || condstoreEnabled) {
            return this.computeModSeqs(mailboxSession, mailbox, messageSet, unchangedSince, qresyncEnabled, condstoreEnabled).flatMap((Function)Throwing.function(modSeqs -> {
                this.sendFetchResponses(responder, request.isUseUids(), silent, unchangedSince, selected, flagsByUid, qresyncEnabled, condstoreEnabled, (Map<MessageUid, ModSeq>)modSeqs);
                if (unchangedSince != -1L) {
                    return mailbox.getMetaDataReactive(MessageManager.MailboxMetaData.RecentMode.IGNORE, mailboxSession, EnumSet.of(MessageManager.MailboxMetaData.Item.HighestModSeq)).doOnNext(metaData -> this.condstoreEnablingCommand(session, responder, (MessageManager.MailboxMetaData)metaData, true));
                }
                return Mono.empty();
            })).then();
        }
        return Mono.empty();
    }

    private void handlePermanentFlagChanges(MailboxSession mailboxSession, MessageManager mailbox, ImapProcessor.Responder responder, SelectedMailbox selected) {
        if (selected.hasNewApplicableFlags()) {
            this.flags(responder, selected);
            this.permanentFlags(responder, mailbox.getPermanentFlags(mailboxSession), selected);
            selected.resetNewApplicableFlags();
        }
    }

    private void sendFetchResponses(ImapProcessor.Responder responder, boolean useUids, boolean silent, long unchangedSince, SelectedMailbox selected, Map<MessageUid, Flags> flagsByUid, boolean qresyncEnabled, boolean condstoreEnabled, Map<MessageUid, ModSeq> modSeqs) {
        for (Map.Entry<MessageUid, Flags> entry : flagsByUid.entrySet()) {
            MessageUid uid = entry.getKey();
            selected.msn(uid).foldSilent(() -> {
                LOGGER.debug("No message found with uid {} in the uid<->msn mapping for mailbox {}. This may be because it was deleted by a concurrent session. So skip it..", (Object)uid, (Object)selected.getMailboxId());
                return null;
            }, msn -> {
                Flags resultFlags = (Flags)entry.getValue();
                Object resultUid = useUids || qresyncEnabled ? uid : null;
                if (selected.isRecent(uid)) {
                    resultFlags.add(Flags.Flag.RECENT);
                }
                FetchResponse response = this.computeFetchResponse(silent, unchangedSince, qresyncEnabled, condstoreEnabled, modSeqs, uid, (MessageSequenceNumber)msn, resultFlags, (MessageUid)resultUid);
                responder.respond(response);
                return null;
            });
        }
    }

    private Mono<Map<MessageUid, ModSeq>> computeModSeqs(MailboxSession mailboxSession, MessageManager mailbox, MessageRange messageSet, long unchangedSince, boolean qresyncEnabled, boolean condstoreEnabled) {
        if (unchangedSince != -1L || qresyncEnabled || condstoreEnabled) {
            return Flux.from((Publisher)mailbox.listMessagesMetadata(messageSet, mailboxSession)).collectMap(r -> r.getComposedMessageId().getUid(), ComposedMessageIdWithMetaData::getModSeq);
        }
        return Mono.just((Object)ImmutableMap.of());
    }

    private FetchResponse computeFetchResponse(boolean silent, long unchangedSince, boolean qresyncEnabled, boolean condstoreEnabled, Map<MessageUid, ModSeq> modSeqs, MessageUid uid, MessageSequenceNumber msn, Flags resultFlags, MessageUid resultUid) {
        if (unchangedSince != -1L || qresyncEnabled || condstoreEnabled) {
            if (silent) {
                return new FetchResponse(msn, null, resultUid, null, modSeqs.get(uid), null, null, null, null, null, null, null, null);
            }
            return new FetchResponse(msn, resultFlags, resultUid, null, modSeqs.get(uid), null, null, null, null, null, null, null, null);
        }
        return new FetchResponse(msn, resultFlags, resultUid, null, null, null, null, null, null, null, null, null, null);
    }

    @Override
    protected MDCBuilder mdc(StoreRequest message) {
        return MDCBuilder.create().addToContext("action", "STORE").addToContext("ranges", IdRange.toString(message.getIdSet())).addToContext("useUids", Boolean.toString(message.isUseUids())).addToContext("unchangedSince", Long.toString(message.getUnchangedSince())).addToContext("isSilent", Boolean.toString(message.isSilent()));
    }
}

