/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.utils.InitializationOperation;

public class InitilizationOperationBuilder {
    public static RequireInit forClass(Class<? extends Startable> type) {
        return init -> new PrivateImpl(init, type);
    }

    @FunctionalInterface
    public static interface RequireInit {
        public PrivateImpl init(Init var1);
    }

    public static class PrivateImpl
    implements InitializationOperation {
        private final Init init;
        private final Class<? extends Startable> type;
        private List<Class<?>> requires;

        private PrivateImpl(Init init, Class<? extends Startable> type) {
            this.init = init;
            this.type = type;
            this.requires = (List)Arrays.stream(type.getDeclaredConstructors()).filter(c -> c.isAnnotationPresent(Inject.class)).findFirst().or(() -> Arrays.stream(type.getDeclaredConstructors()).findFirst()).stream().flatMap(c -> Arrays.stream(c.getParameterTypes())).collect(ImmutableList.toImmutableList());
        }

        @Override
        public void initModule() throws Exception {
            this.init.init();
        }

        @Override
        public Class<? extends Startable> forClass() {
            return this.type;
        }

        public PrivateImpl requires(List<Class<?>> requires) {
            this.requires = requires;
            return this;
        }

        @Override
        public List<Class<?>> requires() {
            return this.requires;
        }
    }

    @FunctionalInterface
    public static interface Init {
        public void init() throws Exception;
    }
}

