/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import javax.inject.Inject;
import org.apache.james.mailbox.indexer.IndexingDetailInformation;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.task.TaskType;

public class PreviousReIndexingService {
    private final TaskManager taskManager;

    @Inject
    public PreviousReIndexingService(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public IndexingDetailInformation retrieveIndexingExecutionDetails(TaskId taskId) throws NotAnIndexingRetriableTask, TaskNotFoundException, TaskNotYetFinishedException {
        TaskExecutionDetails executionDetails = this.taskManager.getExecutionDetails(taskId);
        if (!executionDetails.getStatus().isFinished()) {
            throw new TaskNotYetFinishedException(executionDetails.getStatus());
        }
        return executionDetails.getAdditionalInformation().filter(IndexingDetailInformation.class::isInstance).map(IndexingDetailInformation.class::cast).orElseThrow(() -> new NotAnIndexingRetriableTask(executionDetails.getType()));
    }

    public static class TaskNotYetFinishedException
    extends RuntimeException {
        TaskNotYetFinishedException(TaskManager.Status currentStatus) {
            super("Task is not yet finished. Current status is: " + currentStatus);
        }
    }

    public static class NotAnIndexingRetriableTask
    extends RuntimeException {
        NotAnIndexingRetriableTask(TaskType type) {
            super("'" + type.asString() + "' is not a valid type of task for retrying a failed indexing");
        }
    }
}

