/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.builder;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.builder.MimeMessageWrapper;

public class MimeMessageBuilder {
    public static final String DEFAULT_TEXT_PLAIN_UTF8_TYPE = "text/plain; charset=UTF-8";
    private Optional<String> text = Optional.empty();
    private Optional<String> textContentType = Optional.empty();
    private Optional<String> subject = Optional.empty();
    private Optional<InternetAddress> sender = Optional.empty();
    private Optional<MimeMultipart> content = Optional.empty();
    private ImmutableList.Builder<InternetAddress> from = ImmutableList.builder();
    private ImmutableList.Builder<InternetAddress> cc = ImmutableList.builder();
    private ImmutableList.Builder<InternetAddress> to = ImmutableList.builder();
    private ImmutableList.Builder<InternetAddress> bcc = ImmutableList.builder();
    private ImmutableList.Builder<Header> headers = ImmutableList.builder();

    public static MimeMessageBuilder mimeMessageBuilder() {
        return new MimeMessageBuilder();
    }

    public static MultipartBuilder multipartBuilder() {
        return new MultipartBuilder();
    }

    public static BodyPartBuilder bodyPartBuilder() {
        return new BodyPartBuilder();
    }

    public static BodyPart bodyPartFromBytes(byte[] bytes) throws MessagingException {
        return new MimeBodyPart((InputStream)new ByteArrayInputStream(bytes));
    }

    public MimeMessageBuilder setText(String text) {
        this.text = Optional.of(text);
        return this;
    }

    public MimeMessageBuilder setText(String text, String contentType) {
        this.text = Optional.of(text);
        this.textContentType = Optional.of(contentType);
        return this;
    }

    public MimeMessageBuilder addToRecipient(String text) throws AddressException {
        this.to.add((Object)new InternetAddress(text));
        return this;
    }

    public MimeMessageBuilder setSubject(String subject) {
        this.subject = Optional.ofNullable(subject);
        return this;
    }

    public MimeMessageBuilder setSender(String sender) throws AddressException {
        this.sender = Optional.of(new InternetAddress(sender));
        return this;
    }

    public MimeMessageBuilder addFrom(String from) throws AddressException {
        this.from.add((Object)new InternetAddress(from));
        return this;
    }

    public MimeMessageBuilder addFrom(InternetAddress ... from) throws AddressException {
        this.from.addAll(Arrays.asList(from));
        return this;
    }

    public MimeMessageBuilder addCcRecipient(String text) throws AddressException {
        this.cc.add((Object)new InternetAddress(text));
        return this;
    }

    public MimeMessageBuilder addBccRecipient(String text) throws AddressException {
        this.bcc.add((Object)new InternetAddress(text));
        return this;
    }

    public MimeMessageBuilder addToRecipient(String ... tos) throws AddressException {
        this.to.addAll((Iterable)Arrays.stream(tos).map(Throwing.function(InternetAddress::new)).collect(ImmutableList.toImmutableList()));
        return this;
    }

    public MimeMessageBuilder addCcRecipient(String ... ccs) throws AddressException {
        this.cc.addAll((Iterable)Arrays.stream(ccs).map(Throwing.function(InternetAddress::new)).collect(ImmutableList.toImmutableList()));
        return this;
    }

    public MimeMessageBuilder addBccRecipient(String ... bccs) throws AddressException {
        this.bcc.addAll((Iterable)Arrays.stream(bccs).map(Throwing.function(InternetAddress::new)).collect(ImmutableList.toImmutableList()));
        return this;
    }

    public MimeMessageBuilder addToRecipient(InternetAddress ... tos) throws AddressException {
        this.to.addAll(Arrays.asList(tos));
        return this;
    }

    public MimeMessageBuilder addCcRecipient(InternetAddress ... ccs) throws AddressException {
        this.cc.addAll(Arrays.asList(ccs));
        return this;
    }

    public MimeMessageBuilder addBccRecipient(InternetAddress ... bccs) throws AddressException {
        this.bcc.addAll(Arrays.asList(bccs));
        return this;
    }

    public MimeMessageBuilder setContent(MimeMultipart mimeMultipart) {
        this.content = Optional.of(mimeMultipart);
        return this;
    }

    public MimeMessageBuilder setContent(MultipartBuilder mimeMultipart) throws MessagingException {
        this.content = Optional.of(mimeMultipart.build());
        return this;
    }

    public MimeMessageBuilder setMultipartWithBodyParts(BodyPart ... bobyParts) throws MessagingException {
        this.content = Optional.of(MimeMessageBuilder.multipartBuilder().addBodies(bobyParts).build());
        return this;
    }

    public MimeMessageBuilder setMultipartWithBodyParts(BodyPartBuilder ... bobyParts) throws MessagingException {
        this.content = Optional.of(MimeMessageBuilder.multipartBuilder().addBodies(bobyParts).build());
        return this;
    }

    public MimeMessageBuilder setMultipartWithSubMessage(MimeMessage mimeMessage) throws MessagingException, IOException {
        return this.setMultipartWithBodyParts(new BodyPart[]{new MimeBodyPart(new InternetHeaders((InputStream)new ByteArrayInputStream("Content-Type: multipart/mixed".getBytes(StandardCharsets.US_ASCII))), IOUtils.toByteArray((InputStream)mimeMessage.getInputStream()))});
    }

    public MimeMessageBuilder setMultipartWithSubMessage(MimeMessageBuilder mimeMessage) throws MessagingException, IOException {
        return this.setMultipartWithSubMessage(mimeMessage.build());
    }

    public MimeMessageBuilder addHeader(String name, String value) {
        this.headers.add((Object)new Header(name, value));
        return this;
    }

    public MimeMessageBuilder addHeaders(Header ... headers) {
        return this.addHeaders(Arrays.asList(headers));
    }

    public MimeMessageBuilder addHeaders(Collection<Header> headers) {
        this.headers.addAll(headers);
        return this;
    }

    public MimeMessage build() throws MessagingException {
        ImmutableList bccAddresses;
        ImmutableList ccAddresses;
        ImmutableList toAddresses;
        ImmutableList fromAddresses;
        Preconditions.checkState((!this.text.isPresent() || !this.content.isPresent() ? 1 : 0) != 0, (Object)"Can not get at the same time a text and a content");
        MimeMessage mimeMessage = new MimeMessage(Session.getInstance((Properties)new Properties()));
        if (this.text.isPresent()) {
            mimeMessage.setContent((Object)this.text.get(), this.textContentType.orElse(DEFAULT_TEXT_PLAIN_UTF8_TYPE));
        }
        if (this.content.isPresent()) {
            mimeMessage.setContent((Multipart)this.content.get());
        }
        if (this.sender.isPresent()) {
            mimeMessage.setSender((Address)this.sender.get());
        }
        if (this.subject.isPresent()) {
            mimeMessage.setSubject(this.subject.get());
        }
        if (!(fromAddresses = this.from.build()).isEmpty()) {
            mimeMessage.addFrom((Address[])fromAddresses.toArray(InternetAddress[]::new));
        }
        if (!(toAddresses = this.to.build()).isEmpty()) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])toAddresses.toArray(InternetAddress[]::new));
        }
        if (!(ccAddresses = this.cc.build()).isEmpty()) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses.toArray(InternetAddress[]::new));
        }
        if (!(bccAddresses = this.bcc.build()).isEmpty()) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses.toArray(InternetAddress[]::new));
        }
        MimeMessageWrapper wrappedMessage = MimeMessageWrapper.wrap(mimeMessage);
        ImmutableList headerList = this.headers.build();
        for (Header header : headerList) {
            if (header.name.equals("Message-ID") || header.name.equals("Date")) {
                wrappedMessage.setHeader(header.name, header.value);
                continue;
            }
            wrappedMessage.addHeader(header.name, header.value);
        }
        wrappedMessage.saveChanges();
        return wrappedMessage;
    }

    public static class MultipartBuilder {
        private ImmutableList.Builder<BodyPart> bodyParts = ImmutableList.builder();
        private Optional<String> subType = Optional.empty();

        public MultipartBuilder subType(String subType) {
            this.subType = Optional.of(subType);
            return this;
        }

        public MultipartBuilder addBody(BodyPart bodyPart) {
            this.bodyParts.add((Object)bodyPart);
            return this;
        }

        public MultipartBuilder addBody(BodyPartBuilder bodyPart) throws IOException, MessagingException {
            this.bodyParts.add((Object)bodyPart.build());
            return this;
        }

        public MultipartBuilder addBody(MimeMessageBuilder builder) throws IOException, MessagingException {
            return this.addBody(builder.build());
        }

        public MultipartBuilder addBody(MimeMessage mimeMessage) throws IOException, MessagingException {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)mimeMessage, "message/rfc822");
            this.bodyParts.add((Object)mimeBodyPart);
            return this;
        }

        public MultipartBuilder addBodies(BodyPart ... bodyParts) {
            this.bodyParts.addAll(Arrays.asList(bodyParts));
            return this;
        }

        public MultipartBuilder addBodies(BodyPartBuilder ... bodyParts) {
            this.bodyParts.addAll((Iterable)Arrays.stream(bodyParts).map(Throwing.function(BodyPartBuilder::build).sneakyThrow()).collect(ImmutableList.toImmutableList()));
            return this;
        }

        public MimeMultipart build() throws MessagingException {
            MimeMultipart multipart = new MimeMultipart();
            this.subType.ifPresent((Consumer<String>)Throwing.consumer(arg_0 -> ((MimeMultipart)multipart).setSubType(arg_0)));
            ImmutableList bodyParts = this.bodyParts.build();
            for (BodyPart bodyPart : bodyParts) {
                multipart.addBodyPart(bodyPart);
            }
            return multipart;
        }
    }

    public static class BodyPartBuilder {
        public static final String DEFAULT_VALUE = "";
        private Optional<String> cid = Optional.empty();
        private Optional<String> filename = Optional.empty();
        private ImmutableList.Builder<Header> headers = ImmutableList.builder();
        private Optional<String> disposition = Optional.empty();
        private Optional<String> dataAsString = Optional.empty();
        private Optional<byte[]> dataAsBytes = Optional.empty();
        private Optional<Multipart> dataAsMultipart = Optional.empty();
        private Optional<String> type = Optional.empty();

        public BodyPartBuilder cid(String cid) {
            this.cid = Optional.of(cid);
            return this;
        }

        public BodyPartBuilder filename(String filename) {
            this.filename = Optional.of(filename);
            return this;
        }

        public BodyPartBuilder disposition(String disposition) {
            this.disposition = Optional.of(disposition);
            return this;
        }

        public BodyPartBuilder data(String data) {
            this.dataAsString = Optional.of(data);
            return this;
        }

        public BodyPartBuilder data(Multipart data) {
            this.dataAsMultipart = Optional.of(data);
            return this;
        }

        public BodyPartBuilder data(byte[] data) {
            this.dataAsBytes = Optional.of(data);
            return this;
        }

        public BodyPartBuilder type(String type) {
            this.type = Optional.of(type);
            return this;
        }

        public BodyPartBuilder addHeader(String name, String value) {
            this.headers.add((Object)new Header(name, value));
            return this;
        }

        public BodyPartBuilder addHeaders(Header ... headers) {
            return this.addHeaders(Arrays.asList(headers));
        }

        public BodyPartBuilder addHeaders(Collection<Header> headers) {
            this.headers.addAll(headers);
            return this;
        }

        public BodyPart build() throws IOException, MessagingException {
            Preconditions.checkState((Booleans.countTrue((boolean[])new boolean[]{this.dataAsString.isPresent(), this.dataAsBytes.isPresent(), this.dataAsMultipart.isPresent()}) <= 1 ? 1 : 0) != 0, (Object)"Can not specify data as bytes, multipart and data as string at the same time");
            MimeBodyPart bodyPart = new MimeBodyPart();
            if (this.dataAsBytes.isPresent()) {
                bodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.dataAsBytes.get(), this.type.orElse(MimeMessageBuilder.DEFAULT_TEXT_PLAIN_UTF8_TYPE))));
            } else if (this.dataAsMultipart.isPresent()) {
                bodyPart.setContent(this.dataAsMultipart.get());
            } else {
                bodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.dataAsString.orElse(DEFAULT_VALUE), this.type.orElse(MimeMessageBuilder.DEFAULT_TEXT_PLAIN_UTF8_TYPE))));
            }
            if (this.filename.isPresent()) {
                bodyPart.setFileName(this.filename.get());
            }
            if (this.cid.isPresent()) {
                bodyPart.setContentID(this.cid.get());
            }
            if (this.disposition.isPresent()) {
                bodyPart.setDisposition(this.disposition.get());
            }
            ImmutableList headerList = this.headers.build();
            for (Header header : headerList) {
                bodyPart.addHeader(header.name, header.value);
            }
            return bodyPart;
        }
    }

    public static class Header {
        private final String name;
        private final String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public final boolean equals(Object o) {
            if (o instanceof Header) {
                Header header = (Header)o;
                return Objects.equals(this.name, header.name) && Objects.equals(this.value, header.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.name, this.value);
        }
    }
}

