/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.james.JamesServerMain;

public class ExtraProperties {
    public static final String OVERRIDE_PROPERTY = "extra.props";
    public static final String DEFAULT_PATH = "conf/jvm.properties";

    public static void initialize() {
        String propsPath = System.getProperty(OVERRIDE_PROPERTY, DEFAULT_PATH);
        try (FileInputStream in = new FileInputStream(propsPath);){
            System.getProperties().load(in);
            JamesServerMain.LOGGER.info("Load extra system properties file {}", (Object)propsPath);
        }
        catch (FileNotFoundException e) {
            JamesServerMain.LOGGER.warn("Could not find extra system properties file {}", (Object)propsPath);
        }
        catch (IOException e) {
            JamesServerMain.LOGGER.warn("Failed to load extra system properties from file {} : {}", (Object)propsPath, (Object)e.getMessage());
        }
    }
}

