/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClearMailRepositoryTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"clear-mail-repository");
    private final MailRepositoryStore mailRepositoryStore;
    private final MailRepositoryPath mailRepositoryPath;
    private long initialCount = 0L;

    public ClearMailRepositoryTask(MailRepositoryStore mailRepositoryStore, MailRepositoryPath path) {
        this.mailRepositoryStore = mailRepositoryStore;
        this.mailRepositoryPath = path;
    }

    public Task.Result run() {
        this.initialCount = (Long)this.getRemainingSize().block();
        try {
            this.removeAllInAllRepositories();
            return Task.Result.COMPLETED;
        }
        catch (MailRepositoryStore.MailRepositoryStoreException e) {
            LOGGER.error("Encountered error while clearing repository", (Throwable)e);
            return Task.Result.PARTIAL;
        }
    }

    private void removeAllInAllRepositories() throws MailRepositoryStore.MailRepositoryStoreException {
        this.mailRepositoryStore.getByPath(this.mailRepositoryPath).forEach(Throwing.consumer(MailRepository::removeAll).sneakyThrow());
    }

    public TaskType type() {
        return TYPE;
    }

    MailRepositoryPath getMailRepositoryPath() {
        return this.mailRepositoryPath;
    }

    public Publisher<Optional<TaskExecutionDetails.AdditionalInformation>> detailsReactive() {
        return this.getRemainingSize().map(remainingSize -> new AdditionalInformation(this.mailRepositoryPath, this.initialCount, (long)remainingSize, Clock.systemUTC().instant())).map(Optional::of);
    }

    public Mono<Long> getRemainingSize() {
        try {
            return Flux.fromStream((Stream)this.mailRepositoryStore.getByPath(this.mailRepositoryPath)).flatMap(MailRepository::sizeReactive).reduce((Object)0L, Long::sum);
        }
        catch (MailRepositoryStore.MailRepositoryStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailRepositoryPath repositoryPath;
        private final long initialCount;
        private final long remainingCount;
        private final Instant timestamp;

        public AdditionalInformation(MailRepositoryPath repositoryPath, long initialCount, long remainingCount, Instant timestamp) {
            this.repositoryPath = repositoryPath;
            this.initialCount = initialCount;
            this.remainingCount = remainingCount;
            this.timestamp = timestamp;
        }

        public String getRepositoryPath() {
            return this.repositoryPath.asString();
        }

        public long getRemainingCount() {
            return this.remainingCount;
        }

        public long getInitialCount() {
            return this.initialCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    public static class InvalidMailRepositoryPathDeserializationException
    extends RuntimeException {
        public InvalidMailRepositoryPathDeserializationException(String mailRepositoryPath) {
            super("Unable to deserialize: '" + mailRepositoryPath + "' can not be url decoded");
        }
    }

    public static class UrlEncodingFailureSerializationException
    extends RuntimeException {
        public UrlEncodingFailureSerializationException(MailRepositoryPath mailRepositoryPath) {
            super("Unable to serialize: '" + mailRepositoryPath.asString() + "' can not be url encoded");
        }
    }

    public static class Factory {
        private final MailRepositoryStore mailRepositoryStore;

        @Inject
        public Factory(MailRepositoryStore mailRepositoryStore) {
            this.mailRepositoryStore = mailRepositoryStore;
        }

        public ClearMailRepositoryTask create(MailRepositoryPath mailRepositoryPath) {
            return new ClearMailRepositoryTask(this.mailRepositoryStore, mailRepositoryPath);
        }
    }
}

