/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

class ListenerExecutor {
    private final MetricFactory metricFactory;

    ListenerExecutor(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    Mono<Void> execute(EventListener.ReactiveEventListener listener, MDCBuilder mdcBuilder, Event event) {
        if (listener.isHandling(event)) {
            return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric(EventBus.Metrics.timerName((EventListener)listener), (Publisher)Mono.from((Publisher)listener.reactiveEvent(event)).contextWrite((ContextView)ReactorUtils.context((String)"ListenerExecutor", (MDCBuilder)this.mdc((EventListener)listener, mdcBuilder, event)))));
        }
        return Mono.empty();
    }

    private MDCBuilder mdc(EventListener listener, MDCBuilder mdcBuilder, Event event) {
        return mdcBuilder.addToContext("eventId", event.getEventId().getId().toString()).addToContext("eventClass", event.getClass().getCanonicalName()).addToContext("user", event.getUsername().asString()).addToContext("listenerClass", listener.getClass().getCanonicalName());
    }
}

