/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup.zip;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.mailbox.backup.MailArchiveEntry;
import org.apache.james.mailbox.backup.MailArchiveIterator;
import org.apache.james.mailbox.backup.MailboxWithAnnotationsArchiveEntry;
import org.apache.james.mailbox.backup.SerializedMailboxId;
import org.apache.james.mailbox.backup.UnknownArchiveEntry;
import org.apache.james.mailbox.backup.zip.ExtraFieldExtractor;
import org.apache.james.mailbox.backup.zip.MailboxIdExtraField;
import org.apache.james.mailbox.backup.zip.ZipEntryIterator;
import org.apache.james.mailbox.backup.zip.ZipEntryType;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZippedMailAccountIterator
implements MailArchiveIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZippedMailAccountIterator.class);
    private static final List<MailboxAnnotation> NO_ANNOTATION = ImmutableList.of();
    private final ZipEntryIterator zipEntryIterator;
    private Optional<ZipEntry> next;

    public ZippedMailAccountIterator(ZipEntryIterator zipEntryIterator) {
        this.zipEntryIterator = zipEntryIterator;
        this.next = Optional.ofNullable(zipEntryIterator.next());
    }

    @Override
    public void close() throws IOException {
        this.zipEntryIterator.close();
    }

    @Override
    public boolean hasNext() {
        return this.next.isPresent();
    }

    @Override
    public MailArchiveEntry next() {
        return this.next.map(this::doNext).orElseThrow(() -> new NoSuchElementException());
    }

    private MailArchiveEntry doNext(ZipEntry currentElement) {
        this.next = Optional.ofNullable(this.zipEntryIterator.next());
        try {
            return this.getMailArchiveEntry(currentElement);
        }
        catch (Exception e) {
            LOGGER.error("Error when reading archive on entry : " + currentElement.getName(), (Throwable)e);
            this.next = Optional.empty();
            return new UnknownArchiveEntry(currentElement.getName());
        }
    }

    private MailArchiveEntry getMailArchiveEntry(ZipEntry currentElement) throws Exception {
        Optional<ZipEntryType> entryType = ExtraFieldExtractor.getEntryType(currentElement);
        return entryType.map(Throwing.function(type -> this.from(currentElement, (ZipEntryType)((Object)type))).sneakyThrow()).orElseGet(() -> new UnknownArchiveEntry(currentElement.getName()));
    }

    private Optional<SerializedMailboxId> getMailBoxId(ZipEntry entry) throws ZipException {
        return ExtraFieldExtractor.getStringExtraField(MailboxIdExtraField.ID_AM, entry).map(SerializedMailboxId::new);
    }

    private String getMailboxName(ZipEntry current) {
        return StringUtils.chop((String)current.getName());
    }

    private MailArchiveEntry fromMailboxEntry(ZipEntry current) throws ZipException {
        return new MailboxWithAnnotationsArchiveEntry(this.getMailboxName(current), this.getMailBoxId(current).get(), NO_ANNOTATION);
    }

    private MailArchiveEntry from(ZipEntry current, ZipEntryType currentEntryType) throws ZipException {
        switch (currentEntryType) {
            case MAILBOX: {
                return this.fromMailboxEntry(current);
            }
        }
        return new UnknownArchiveEntry(current.getName());
    }
}

