/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.json.DTOConverter;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.task.TaskType;
import org.apache.james.util.DurationParser;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.ExecutionDetailsDto;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

public class TasksRoutes
implements Routes {
    private static final Duration MAXIMUM_AWAIT_TIMEOUT = Duration.ofDays(365L);
    public static final String BASE = "/tasks";
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;
    private final DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO> additionalInformationDTOConverter;

    @Inject
    public TasksRoutes(TaskManager taskManager, JsonTransformer jsonTransformer, @Named(value="webadmin-dto") DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO> additionalInformationDTOConverter) {
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
        this.additionalInformationDTOConverter = additionalInformationDTOConverter;
    }

    @Override
    public String getBasePath() {
        return BASE;
    }

    @Override
    public void define(Service service) {
        service.get("/tasks/:id", this::getStatus, (ResponseTransformer)this.jsonTransformer);
        service.get("/tasks/:id/await", this::await, (ResponseTransformer)this.jsonTransformer);
        service.delete("/tasks/:id", this::cancel, (ResponseTransformer)this.jsonTransformer);
        service.get(BASE, this::list, (ResponseTransformer)this.jsonTransformer);
    }

    public Object list(Request req, Response response) {
        try {
            return ExecutionDetailsDto.from(this.additionalInformationDTOConverter, this.listTasks(req));
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).cause(e).message("Invalid status query parameter").haltError();
        }
    }

    private Stream<TaskExecutionDetails> listTasks(Request req) {
        Stream<TaskExecutionDetails> stream = Optional.ofNullable(req.queryParams("status")).map(TaskManager.Status::fromString).map(arg_0 -> ((TaskManager)this.taskManager).list(arg_0)).orElse(this.taskManager.list()).stream().sorted(Comparator.comparing(TaskExecutionDetails::getSubmittedDate).reversed());
        return this.taskListTransformations(req).reduce(stream, (s, tc) -> (Stream)tc.apply(s), Stream::concat);
    }

    Stream<TaskListTransformation> taskListTransformations(Request req) {
        return Stream.of(Optional.ofNullable(req.queryParams("type")).map(TaskType::of).map(TypeTaskListTransformation::new), Optional.ofNullable(req.queryParams("failedBefore")).map(this::parseDate).map(FailedBeforeTaskListTransformation::new), Optional.ofNullable(req.queryParams("failedAfter")).map(this::parseDate).map(FailedAfterTaskListTransformation::new), Optional.ofNullable(req.queryParams("completedBefore")).map(this::parseDate).map(CompletedBeforeTaskListTransformation::new), Optional.ofNullable(req.queryParams("completedAfter")).map(this::parseDate).map(CompletedAfterTaskListTransformation::new), Optional.ofNullable(req.queryParams("startedBefore")).map(this::parseDate).map(StartedBeforeTaskListTransformation::new), Optional.ofNullable(req.queryParams("startedAfter")).map(this::parseDate).map(StartedAfterTaskListTransformation::new), Optional.ofNullable(req.queryParams("submittedBefore")).map(this::parseDate).map(SubmittedBeforeTaskListTransformation::new), Optional.ofNullable(req.queryParams("submittedAfter")).map(this::parseDate).map(SubmittedAfterTaskListTransformation::new), Optional.ofNullable(req.queryParams("offset")).map(Integer::valueOf).map(OffsetTaskListTransformation::new), Optional.ofNullable(req.queryParams("limit")).map(Integer::valueOf).map(LimitTaskListTransformation::new)).flatMap(Optional::stream);
    }

    private ZonedDateTime parseDate(String s) {
        try {
            return ZonedDateTime.parse(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object getStatus(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        return this.respondStatus(taskId, () -> this.taskManager.getExecutionDetails(this.getTaskId(req)));
    }

    public Object await(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        Duration timeout = this.getTimeout(req);
        return this.respondStatus(taskId, () -> this.awaitTask(taskId, timeout));
    }

    private Object respondStatus(TaskId taskId, Supplier<TaskExecutionDetails> executionDetailsSupplier) {
        try {
            TaskExecutionDetails executionDetails = executionDetailsSupplier.get();
            return ExecutionDetailsDto.from(this.additionalInformationDTOConverter, executionDetails);
        }
        catch (TaskNotFoundException e) {
            throw ErrorResponder.builder().message("%s can not be found", taskId.getValue()).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError();
        }
    }

    public Object cancel(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        this.taskManager.cancel(taskId);
        return Responses.returnNoContent(response);
    }

    private TaskId getTaskId(Request req) {
        try {
            String id = req.params("id");
            return TaskId.fromString((String)id);
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid task id").haltError();
        }
    }

    private Duration getTimeout(Request req) {
        try {
            Duration timeout = Optional.ofNullable(req.queryParams("timeout")).filter(Predicate.not(String::isEmpty)).map(rawString -> DurationParser.parse((String)rawString, (ChronoUnit)ChronoUnit.SECONDS)).orElse(MAXIMUM_AWAIT_TIMEOUT);
            this.assertDoesNotExceedMaximumTimeout(timeout);
            return timeout;
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid timeout").haltError();
        }
    }

    private void assertDoesNotExceedMaximumTimeout(Duration timeout) {
        Preconditions.checkState((timeout.compareTo(MAXIMUM_AWAIT_TIMEOUT) <= 0 ? 1 : 0) != 0, (Object)"Timeout should not exceed 365 days");
    }

    private TaskExecutionDetails awaitTask(TaskId taskId, Duration timeout) {
        try {
            return this.taskManager.await(taskId, timeout);
        }
        catch (TaskManager.ReachedTimeoutException e) {
            throw ErrorResponder.builder().statusCode(408).type(ErrorResponder.ErrorType.SERVER_ERROR).message("The timeout has been reached").haltError();
        }
        catch (TaskNotFoundException e) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.SERVER_ERROR).message("The taskId is not found").haltError();
        }
    }

    static interface TaskListTransformation
    extends Function<Stream<TaskExecutionDetails>, Stream<TaskExecutionDetails>> {
    }

    static class LimitTaskListTransformation
    implements TaskListTransformation {
        private final int limit;

        LimitTaskListTransformation(int limit) {
            Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"'limit' should be positive");
            this.limit = limit;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.limit(this.limit);
        }
    }

    static class OffsetTaskListTransformation
    implements TaskListTransformation {
        private final int offset;

        OffsetTaskListTransformation(int offset) {
            Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"'offset' should be positive");
            this.offset = offset;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.skip(this.offset);
        }
    }

    static class CompletedAfterTaskListTransformation
    implements TaskListTransformation {
        private final ZonedDateTime time;

        public CompletedAfterTaskListTransformation(ZonedDateTime time) {
            this.time = time;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.filter(taskExecutionDetails -> taskExecutionDetails.getCompletedDate().map(started -> started.isAfter(this.time)).orElse(false));
        }
    }

    static class FailedAfterTaskListTransformation
    implements TaskListTransformation {
        private final ZonedDateTime time;

        public FailedAfterTaskListTransformation(ZonedDateTime time) {
            this.time = time;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.filter(taskExecutionDetails -> taskExecutionDetails.getFailedDate().map(started -> started.isAfter(this.time)).orElse(false));
        }
    }

    static class StartedAfterTaskListTransformation
    implements TaskListTransformation {
        private final ZonedDateTime time;

        public StartedAfterTaskListTransformation(ZonedDateTime time) {
            this.time = time;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.filter(taskExecutionDetails -> taskExecutionDetails.getStartedDate().map(started -> started.isAfter(this.time)).orElse(false));
        }
    }

    static class SubmittedAfterTaskListTransformation
    implements TaskListTransformation {
        private final ZonedDateTime time;

        public SubmittedAfterTaskListTransformation(ZonedDateTime time) {
            this.time = time;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.filter(taskExecutionDetails -> taskExecutionDetails.getSubmittedDate().isAfter(this.time));
        }
    }

    static class CompletedBeforeTaskListTransformation
    implements TaskListTransformation {
        private final ZonedDateTime time;

        public CompletedBeforeTaskListTransformation(ZonedDateTime time) {
            this.time = time;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.filter(taskExecutionDetails -> taskExecutionDetails.getCompletedDate().map(started -> started.isBefore(this.time)).orElse(false));
        }
    }

    static class FailedBeforeTaskListTransformation
    implements TaskListTransformation {
        private final ZonedDateTime time;

        public FailedBeforeTaskListTransformation(ZonedDateTime time) {
            this.time = time;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.filter(taskExecutionDetails -> taskExecutionDetails.getFailedDate().map(started -> started.isBefore(this.time)).orElse(false));
        }
    }

    static class StartedBeforeTaskListTransformation
    implements TaskListTransformation {
        private final ZonedDateTime time;

        public StartedBeforeTaskListTransformation(ZonedDateTime time) {
            this.time = time;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.filter(taskExecutionDetails -> taskExecutionDetails.getStartedDate().map(started -> started.isBefore(this.time)).orElse(false));
        }
    }

    static class SubmittedBeforeTaskListTransformation
    implements TaskListTransformation {
        private final ZonedDateTime time;

        public SubmittedBeforeTaskListTransformation(ZonedDateTime time) {
            this.time = time;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.filter(taskExecutionDetails -> taskExecutionDetails.getSubmittedDate().isBefore(this.time));
        }
    }

    static class TypeTaskListTransformation
    implements TaskListTransformation {
        private final TaskType taskType;

        TypeTaskListTransformation(TaskType taskType) {
            this.taskType = taskType;
        }

        @Override
        public Stream<TaskExecutionDetails> apply(Stream<TaskExecutionDetails> stream) {
            return stream.filter(taskExecutionDetails -> taskExecutionDetails.getType().equals((Object)this.taskType));
        }
    }
}

