/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet.filter;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.mailet.filter.HeaderExtractor;
import org.apache.james.util.OptionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ContentMatcher {
    public static final ContentMatcher STRING_CONTAINS_MATCHER = (contents, valueToMatch) -> contents.anyMatch(content -> StringUtils.contains((CharSequence)content, (CharSequence)valueToMatch));
    public static final ContentMatcher STRING_NOT_CONTAINS_MATCHER = ContentMatcher.negate(STRING_CONTAINS_MATCHER);
    public static final ContentMatcher STRING_EXACTLY_EQUALS_MATCHER = (contents, valueToMatch) -> contents.anyMatch(content -> StringUtils.equals((CharSequence)content, (CharSequence)valueToMatch));
    public static final ContentMatcher STRING_NOT_EXACTLY_EQUALS_MATCHER = ContentMatcher.negate(STRING_EXACTLY_EQUALS_MATCHER);
    public static final ContentMatcher ADDRESS_CONTAINS_MATCHER = (contents, valueToMatch) -> contents.map(ContentMatcher::asAddressHeader).anyMatch(addressHeader -> StringUtils.containsIgnoreCase((CharSequence)addressHeader.fullAddress, (CharSequence)valueToMatch));
    public static final ContentMatcher ADDRESS_NOT_CONTAINS_MATCHER = ContentMatcher.negate(ADDRESS_CONTAINS_MATCHER);
    public static final ContentMatcher ADDRESS_NOT_EXACTLY_EQUALS_MATCHER = ContentMatcher.negate(new ExactAddressContentMatcher());
    public static final Map<Rule.Condition.Comparator, ContentMatcher> HEADER_ADDRESS_MATCHER_REGISTRY = ImmutableMap.builder().put((Object)Rule.Condition.Comparator.CONTAINS, (Object)ADDRESS_CONTAINS_MATCHER).put((Object)Rule.Condition.Comparator.NOT_CONTAINS, (Object)ADDRESS_NOT_CONTAINS_MATCHER).put((Object)Rule.Condition.Comparator.EXACTLY_EQUALS, (Object)new ExactAddressContentMatcher()).put((Object)Rule.Condition.Comparator.NOT_EXACTLY_EQUALS, (Object)ADDRESS_NOT_EXACTLY_EQUALS_MATCHER).build();
    public static final Map<Rule.Condition.Comparator, ContentMatcher> CONTENT_STRING_MATCHER_REGISTRY = ImmutableMap.builder().put((Object)Rule.Condition.Comparator.CONTAINS, (Object)STRING_CONTAINS_MATCHER).put((Object)Rule.Condition.Comparator.NOT_CONTAINS, (Object)STRING_NOT_CONTAINS_MATCHER).put((Object)Rule.Condition.Comparator.EXACTLY_EQUALS, (Object)STRING_EXACTLY_EQUALS_MATCHER).put((Object)Rule.Condition.Comparator.NOT_EXACTLY_EQUALS, (Object)STRING_NOT_EXACTLY_EQUALS_MATCHER).build();
    public static final Map<Rule.Condition.Field, Map<Rule.Condition.Comparator, ContentMatcher>> CONTENT_MATCHER_REGISTRY = ImmutableMap.builder().put((Object)Rule.Condition.Field.SUBJECT, CONTENT_STRING_MATCHER_REGISTRY).put((Object)Rule.Condition.Field.TO, HEADER_ADDRESS_MATCHER_REGISTRY).put((Object)Rule.Condition.Field.CC, HEADER_ADDRESS_MATCHER_REGISTRY).put((Object)Rule.Condition.Field.RECIPIENT, HEADER_ADDRESS_MATCHER_REGISTRY).put((Object)Rule.Condition.Field.FROM, HEADER_ADDRESS_MATCHER_REGISTRY).build();

    public static ContentMatcher negate(ContentMatcher contentMatcher) {
        return (contents, valueToMatch) -> !contentMatcher.match(contents, valueToMatch);
    }

    public static Optional<ContentMatcher> asContentMatcher(Rule.Condition.Field field, Rule.Condition.Comparator comparator) {
        return Optional.ofNullable(CONTENT_MATCHER_REGISTRY.get(field)).map(matcherRegistry -> (ContentMatcher)matcherRegistry.get(comparator));
    }

    public static AddressHeader asAddressHeader(String addressAsString) {
        return new AddressHeader(addressAsString);
    }

    public boolean match(Stream<String> var1, String var2);

    public static class AddressHeader {
        private static final Logger LOGGER = LoggerFactory.getLogger(AddressHeader.class);
        private final Optional<String> personal;
        private final Optional<String> address;
        private final String fullAddress;

        private AddressHeader(String fullAddress) {
            this.fullAddress = fullAddress;
            Optional<InternetAddress> internetAddress = this.parseFullAddress();
            this.address = internetAddress.map(InternetAddress::getAddress);
            this.personal = internetAddress.map(InternetAddress::getPersonal).or(() -> this.address).or(() -> Optional.of(fullAddress));
        }

        private Optional<InternetAddress> parseFullAddress() {
            try {
                return Optional.of(new InternetAddress(this.fullAddress));
            }
            catch (AddressException e) {
                LOGGER.info("error while parsing full address {}", (Object)this.fullAddress, (Object)e);
                return Optional.empty();
            }
        }

        boolean matchesIgnoreCase(AddressHeader other) {
            boolean sameAddress = OptionalUtils.matches(this.address, other.address, String::equalsIgnoreCase);
            boolean samePersonal = OptionalUtils.matches(this.personal, other.personal, String::equalsIgnoreCase);
            boolean personalMatchesAddress = OptionalUtils.matches(this.personal, other.address, String::equalsIgnoreCase);
            boolean addressMatchesPersonal = OptionalUtils.matches(this.address, other.personal, String::equalsIgnoreCase);
            return this.fullAddress.equalsIgnoreCase(other.fullAddress) || sameAddress && samePersonal || sameAddress && !this.personal.isPresent() || samePersonal && !this.address.isPresent() || personalMatchesAddress && sameAddress || addressMatchesPersonal && samePersonal;
        }
    }

    public static class ExactAddressContentMatcher
    implements ContentMatcher {
        @Override
        public boolean match(Stream<String> contents, String valueToMatch) {
            AddressHeader addressHeaderToMatch = HeaderExtractor.toAddressContents(new String[]{valueToMatch}).map(x$0 -> new AddressHeader((String)x$0)).findAny().orElseGet(() -> new AddressHeader(valueToMatch));
            return contents.map(ContentMatcher::asAddressHeader).anyMatch(addressHeaderToMatch::matchesIgnoreCase);
        }
    }
}

