/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import javax.inject.Inject;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.MessageBatcher;

public class MailboxManagerConfiguration {
    public static final MailboxManagerConfiguration DEFAULT = new MailboxManagerConfiguration(BatchSizes.defaultValues());
    private final BatchSizes batchSizes;

    @Inject
    public MailboxManagerConfiguration(BatchSizes batchSizes) {
        this.batchSizes = batchSizes;
    }

    public BatchSizes getBatchSizes() {
        return this.batchSizes;
    }

    public MessageBatcher getCopyBatcher() {
        return new MessageBatcher(this.batchSizes.getCopyBatchSize().orElse(0));
    }

    public MessageBatcher getMoveBatcher() {
        return new MessageBatcher(this.batchSizes.getMoveBatchSize().orElse(0));
    }

    static class NoMailboxConfiguration
    extends MailboxManagerConfiguration {
        public NoMailboxConfiguration() {
            super(BatchSizes.defaultValues());
        }
    }
}

