/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.function.Function;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.GeoDistanceSort;
import org.opensearch.client.opensearch._types.ScoreSort;
import org.opensearch.client.opensearch._types.ScriptSort;
import org.opensearch.client.opensearch._types.SortOptionsVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class SortOptions
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<SortOptions> _DESERIALIZER = JsonpDeserializer.lazy(() -> JsonpDeserializer.of(EnumSet.of(JsonParser.Event.START_OBJECT, JsonParser.Event.VALUE_STRING), (parser, mapper) -> {
        Builder b = new Builder();
        JsonParser.Event event = parser.next();
        if (event == JsonParser.Event.VALUE_STRING) {
            switch (parser.getString()) {
                case "_score": {
                    b.score(s -> s);
                    break;
                }
                case "_doc": {
                    b.doc(d -> d);
                    break;
                }
                default: {
                    b.field(f -> f.field(parser.getString()));
                }
            }
            return b.build();
        }
        JsonpUtils.expectEvent(parser, JsonParser.Event.START_OBJECT, event);
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.KEY_NAME);
        switch (parser.getString()) {
            case "_score": {
                b.score(ScoreSort._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
                break;
            }
            case "_doc": {
                b.doc(ScoreSort._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
                break;
            }
            case "_geo_distance": {
                b.geoDistance(GeoDistanceSort._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
                break;
            }
            case "_script": {
                b.script(ScriptSort._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
                break;
            }
            default: {
                return b.field(FieldSort._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper, JsonParser.Event.KEY_NAME)).build();
            }
        }
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
        return b.build();
    }));

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public SortOptions(SortOptionsVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._sortOptionsKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private SortOptions(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static SortOptions of(Function<Builder, ObjectBuilder<SortOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isScore() {
        return this._kind == Kind.Score;
    }

    public ScoreSort score() {
        return (ScoreSort)TaggedUnionUtils.get(this, Kind.Score);
    }

    public boolean isDoc() {
        return this._kind == Kind.Doc;
    }

    public ScoreSort doc() {
        return (ScoreSort)TaggedUnionUtils.get(this, Kind.Doc);
    }

    public boolean isGeoDistance() {
        return this._kind == Kind.GeoDistance;
    }

    public GeoDistanceSort geoDistance() {
        return (GeoDistanceSort)TaggedUnionUtils.get(this, Kind.GeoDistance);
    }

    public boolean isScript() {
        return this._kind == Kind.Script;
    }

    public ScriptSort script() {
        return (ScriptSort)TaggedUnionUtils.get(this, Kind.Script);
    }

    public boolean isField() {
        return this._kind == Kind.Field;
    }

    public FieldSort field() {
        return (FieldSort)TaggedUnionUtils.get(this, Kind.Field);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this.isField()) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            generator.writeStartObject();
            generator.writeKey(this._kind.jsonValue());
            if (this._value instanceof JsonpSerializable) {
                ((JsonpSerializable)this._value).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SortOptions> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<SortOptions> score(ScoreSort v) {
            this._kind = Kind.Score;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SortOptions> score(Function<ScoreSort.Builder, ObjectBuilder<ScoreSort>> fn) {
            return this.score(fn.apply(new ScoreSort.Builder()).build());
        }

        public ObjectBuilder<SortOptions> doc(ScoreSort v) {
            this._kind = Kind.Doc;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SortOptions> doc(Function<ScoreSort.Builder, ObjectBuilder<ScoreSort>> fn) {
            return this.doc(fn.apply(new ScoreSort.Builder()).build());
        }

        public ObjectBuilder<SortOptions> geoDistance(GeoDistanceSort v) {
            this._kind = Kind.GeoDistance;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SortOptions> geoDistance(Function<GeoDistanceSort.Builder, ObjectBuilder<GeoDistanceSort>> fn) {
            return this.geoDistance(fn.apply(new GeoDistanceSort.Builder()).build());
        }

        public ObjectBuilder<SortOptions> script(ScriptSort v) {
            this._kind = Kind.Script;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SortOptions> script(Function<ScriptSort.Builder, ObjectBuilder<ScriptSort>> fn) {
            return this.script(fn.apply(new ScriptSort.Builder()).build());
        }

        public ObjectBuilder<SortOptions> field(FieldSort v) {
            this._kind = Kind.Field;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SortOptions> field(Function<FieldSort.Builder, ObjectBuilder<FieldSort>> fn) {
            return this.field(fn.apply(new FieldSort.Builder()).build());
        }

        @Override
        public SortOptions build() {
            this._checkSingleUse();
            return new SortOptions(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Score("_score"),
        Doc("_doc"),
        GeoDistance("_geo_distance"),
        Script("_script"),
        Field("field");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

