/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableList;
import java.io.UnsupportedEncodingException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.core.MailAddress;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.SeparatingDataLineFilter;

public class ReceivedDataLineFilter
extends SeparatingDataLineFilter {
    private static final String EHLO = "EHLO";
    private static final String SMTP = "SMTP";
    private static final String ESMTPA = "ESMTPA";
    private static final String ESMTP = "ESMTP";
    private static final DateTimeFormatter DATEFORMAT = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z (zzz)", Locale.US);
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final ProtocolSession.AttachmentKey<Boolean> headersPrefixAdded = ProtocolSession.AttachmentKey.of((String)("HEADERS_PREFIX_ADDED" + COUNTER.incrementAndGet()), Boolean.class);
    private final ProtocolSession.AttachmentKey<Boolean> headersSuffixAdded = ProtocolSession.AttachmentKey.of((String)("HEADERS_SUFFIX_ADDED" + COUNTER.incrementAndGet()), Boolean.class);

    protected String getServiceType(SMTPSession session, String heloMode) {
        if (EHLO.equals(heloMode)) {
            if (session.getUsername() == null) {
                return ESMTP;
            }
            return ESMTPA;
        }
        return SMTP;
    }

    protected Location getLocation() {
        return Location.PREFIX;
    }

    protected Collection<Header> headers(SMTPSession session) {
        StringBuilder headerLineBuffer = new StringBuilder();
        Optional heloMode = session.getAttachment(SMTPSession.CURRENT_HELO_MODE, ProtocolSession.State.Connection);
        Optional heloName = session.getAttachment(SMTPSession.CURRENT_HELO_NAME, ProtocolSession.State.Connection);
        headerLineBuffer.append("from ").append(session.getRemoteAddress().getHostName());
        if (heloName.isPresent() && heloMode.isPresent()) {
            headerLineBuffer.append(" (").append((String)heloMode.get()).append(" ").append((String)heloName.get()).append(")");
        }
        headerLineBuffer.append(" ([").append(session.getRemoteAddress().getAddress().getHostAddress()).append("])");
        Header header = new Header("Received", headerLineBuffer.toString());
        headerLineBuffer = new StringBuilder();
        headerLineBuffer.append("by ").append(session.getConfiguration().getHelloName()).append(" (").append(session.getConfiguration().getSoftwareName()).append(") with ").append(this.getServiceType(session, heloMode.orElse("NOT-DEFINED")));
        headerLineBuffer.append(" ID ").append(session.getSessionID());
        List rcptList = (List)session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
        if (rcptList.size() == 1) {
            header.add(headerLineBuffer.toString());
            headerLineBuffer = new StringBuilder();
            headerLineBuffer.append("for <").append(((MailAddress)rcptList.get(0)).toString()).append(">;");
        } else {
            headerLineBuffer.append(";");
        }
        header.add(headerLineBuffer.toString());
        headerLineBuffer = new StringBuilder();
        headerLineBuffer.append(DATEFORMAT.format(ZonedDateTime.now()));
        header.add(headerLineBuffer.toString());
        return Collections.singletonList(header);
    }

    @Override
    protected Response onSeparatorLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        if (this.getLocation() == Location.SUFFIX && !session.getAttachment(this.headersSuffixAdded, ProtocolSession.State.Transaction).isPresent()) {
            session.setAttachment(this.headersSuffixAdded, Boolean.TRUE, ProtocolSession.State.Transaction);
            return this.addHeaders(session, line, next);
        }
        return super.onSeparatorLine(session, line, next);
    }

    @Override
    protected Response onHeadersLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        if (this.getLocation() == Location.PREFIX && !session.getAttachment(this.headersPrefixAdded, ProtocolSession.State.Transaction).isPresent()) {
            session.setAttachment(this.headersPrefixAdded, Boolean.TRUE, ProtocolSession.State.Transaction);
            return this.addHeaders(session, line, next);
        }
        return super.onHeadersLine(session, line, next);
    }

    private Response addHeaders(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        for (Header header : this.headers(session)) {
            Response response = header.transferTo(session, next);
            if (response == null) continue;
            return response;
        }
        return next.onLine((ProtocolSession)session, line);
    }

    static enum Location {
        PREFIX,
        SUFFIX;

    }

    public static final class Header {
        public static final String MULTI_LINE_PREFIX = "          ";
        public final String name;
        public final List<String> values = new ArrayList<String>();

        public Header(String name, String value) {
            this.name = name;
            this.values.add(value);
        }

        public Header add(String value) {
            this.values.add(value);
            return this;
        }

        public Response transferTo(SMTPSession session, LineHandler<SMTPSession> handler) {
            String charset = session.getCharset().name();
            try {
                String line;
                Response response = null;
                for (int i = 0; i < this.values.size() && (response = handler.onLine((ProtocolSession)session, ((line = i == 0 ? this.name + ": " + this.values.get(i) : MULTI_LINE_PREFIX + this.values.get(i)) + session.getLineDelimiter()).getBytes(charset))) == null; ++i) {
                }
                return response;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("NO " + charset + " support ?", e);
            }
        }
    }
}

