/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;

public abstract class AbstractServerFactory
implements Configurable {
    private List<AbstractConfigurableAsyncServer> servers;
    private HierarchicalConfiguration<ImmutableNode> config;

    protected abstract List<AbstractConfigurableAsyncServer> createServers(HierarchicalConfiguration<ImmutableNode> var1) throws Exception;

    public void configure(HierarchicalConfiguration<ImmutableNode> config) {
        this.config = config;
    }

    @PostConstruct
    public void init() throws Exception {
        this.servers = this.createServers(this.config);
        for (AbstractConfigurableAsyncServer server : this.servers) {
            server.init();
        }
    }

    public List<AbstractConfigurableAsyncServer> getServers() {
        return this.servers;
    }

    @PreDestroy
    public void destroy() {
        for (AbstractConfigurableAsyncServer server : this.servers) {
            server.destroy();
        }
    }
}

