/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import org.apache.james.imap.api.message.BodyFetchElement;

public class FetchData {
    private final EnumSet<Item> itemToFetch;
    private final ImmutableSet<BodyFetchElement> bodyElements;
    private final boolean setSeen;
    private final long changedSince;
    private final boolean vanished;

    public static Builder builder() {
        return new Builder();
    }

    private FetchData(EnumSet<Item> itemToFetch, ImmutableSet<BodyFetchElement> bodyElements, boolean setSeen, long changedSince, boolean vanished) {
        this.itemToFetch = itemToFetch;
        this.bodyElements = bodyElements;
        this.setSeen = setSeen;
        this.changedSince = changedSince;
        this.vanished = vanished;
    }

    public Collection<BodyFetchElement> getBodyElements() {
        return this.bodyElements;
    }

    public boolean contains(Item item) {
        return this.itemToFetch.contains((Object)item);
    }

    public boolean isSetSeen() {
        return this.setSeen;
    }

    public long getChangedSince() {
        return this.changedSince;
    }

    public boolean getVanished() {
        return this.vanished;
    }

    public boolean isOnlyFlags() {
        return this.bodyElements.isEmpty() && this.itemToFetch.stream().filter(item -> item != Item.FLAGS).filter(item -> item != Item.UID).filter(item -> item != Item.MODSEQ).findAny().isEmpty();
    }

    public final int hashCode() {
        return Objects.hash(this.itemToFetch, this.bodyElements, this.setSeen, this.changedSince);
    }

    public final boolean equals(Object o) {
        if (o instanceof FetchData) {
            FetchData fetchData = (FetchData)o;
            return Objects.equals(this.setSeen, fetchData.setSeen) && Objects.equals(this.changedSince, fetchData.changedSince) && Objects.equals(this.itemToFetch, fetchData.itemToFetch) && Objects.equals(this.bodyElements, fetchData.bodyElements);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)FetchData.class.getSimpleName()).omitNullValues().add("items", this.itemToFetch).add("setSeen", this.setSeen).add("bodyElements", this.bodyElements).add("changedSince", this.changedSince).add("vanished", this.vanished).toString();
    }

    public static class Builder {
        private final EnumSet<Item> itemToFetch = EnumSet.noneOf(Item.class);
        private final ImmutableSet.Builder<BodyFetchElement> bodyElements = ImmutableSet.builder();
        private boolean setSeen = false;
        private long changedSince = -1L;
        private boolean vanished;

        public static Builder from(FetchData fetchData) {
            return FetchData.builder().fetch(fetchData.itemToFetch).vanished(fetchData.vanished).changedSince(fetchData.changedSince).addBodyElements((Collection<BodyFetchElement>)fetchData.bodyElements).seen(fetchData.setSeen);
        }

        public Builder fetch(Item item) {
            this.itemToFetch.add(item);
            return this;
        }

        public Builder fetch(Item ... item) {
            return this.fetch(Arrays.asList(item));
        }

        public Builder fetch(Collection<Item> items) {
            this.itemToFetch.addAll(items);
            return this;
        }

        public Builder changedSince(long changedSince) {
            this.changedSince = changedSince;
            return this.fetch(Item.MODSEQ);
        }

        public Builder vanished(boolean vanished) {
            this.vanished = vanished;
            return this;
        }

        public Builder add(BodyFetchElement element, boolean peek) {
            if (!peek) {
                this.setSeen = true;
            }
            this.bodyElements.add((Object)element);
            return this;
        }

        private Builder addBodyElements(Collection<BodyFetchElement> elements) {
            this.bodyElements.addAll(elements);
            return this;
        }

        private Builder seen(boolean setSeen) {
            this.setSeen = setSeen;
            return this;
        }

        public FetchData build() {
            return new FetchData(this.itemToFetch, (ImmutableSet<BodyFetchElement>)this.bodyElements.build(), this.setSeen, this.changedSince, this.vanished);
        }
    }

    public static enum Item {
        FLAGS,
        UID,
        INTERNAL_DATE,
        SIZE,
        ENVELOPE,
        BODY,
        BODY_STRUCTURE,
        MODSEQ,
        EMAILID,
        THREADID,
        SAVEDATE;

    }
}

