/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.mail.internet.AddressException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.SkipMappingProcessingException;
import org.apache.james.rrt.lib.UserRewritter;

public interface Mapping {
    public static Mapping of(String mapping) {
        Type type = Mapping.detectType(mapping);
        return Mapping.of(type, type.withoutPrefix(mapping));
    }

    public static Mapping of(Type type, String mapping) {
        return new Impl(type, mapping);
    }

    public static Mapping address(String mapping) {
        return Mapping.of(Type.Address, mapping);
    }

    public static Mapping regex(String mapping) {
        return Mapping.of(Type.Regex, mapping);
    }

    public static Mapping error(String mapping) {
        return Mapping.of(Type.Error, mapping);
    }

    public static Mapping domain(Domain mapping) {
        return Mapping.of(Type.Domain, mapping.asString());
    }

    public static Mapping domainAlias(Domain mapping) {
        return Mapping.of(Type.DomainAlias, mapping.asString());
    }

    public static Mapping forward(String mapping) {
        return Mapping.of(Type.Forward, mapping);
    }

    public static Mapping group(String mapping) {
        return Mapping.of(Type.Group, mapping);
    }

    public static Mapping alias(String mapping) {
        return Mapping.of(Type.Alias, mapping);
    }

    public static Type detectType(String input) {
        return Arrays.stream(Type.values()).filter(Type::hasPrefix).filter(type -> input.startsWith(type.asPrefix())).findAny().orElse(Type.Address);
    }

    public Optional<MailAddress> asMailAddress();

    public Stream<Mapping> handleIdentity(Stream<Mapping> var1);

    public Type getType();

    public String getMappingValue();

    public String asString();

    public boolean hasDomain();

    public Mapping appendDomainFromThrowingSupplierIfNone(ThrowingDomainSupplier var1) throws RecipientRewriteTableException;

    public Mapping appendDomainIfNone(Supplier<Domain> var1);

    public String getErrorMessage();

    public Optional<Username> rewriteUser(Username var1) throws AddressException, RecipientRewriteTable.ErrorMappingException;

    public static enum Type {
        Regex("regex:", new UserRewritter.RegexRewriter(), IdentityMappingPolicy.Throw, MailAddressConversionPolicy.ToEmpty, TypeOrder.TYPE_ORDER_4),
        Domain("domain:", new UserRewritter.DomainRewriter(), IdentityMappingPolicy.Throw, MailAddressConversionPolicy.ToEmpty, TypeOrder.TYPE_ORDER_1),
        DomainAlias("domainAlias:", new UserRewritter.DomainRewriter(), IdentityMappingPolicy.Throw, MailAddressConversionPolicy.ToEmpty, TypeOrder.TYPE_ORDER_1),
        Error("error:", new UserRewritter.ThrowingRewriter(), IdentityMappingPolicy.Throw, MailAddressConversionPolicy.ToEmpty, TypeOrder.TYPE_ORDER_4),
        Forward("forward:", new UserRewritter.ReplaceRewriter(), IdentityMappingPolicy.ReturnIdentity, MailAddressConversionPolicy.ToMailAddress, TypeOrder.TYPE_ORDER_3),
        Group("group:", new UserRewritter.ReplaceRewriter(), IdentityMappingPolicy.Throw, MailAddressConversionPolicy.ToMailAddress, TypeOrder.TYPE_ORDER_2),
        Alias("alias:", new UserRewritter.ReplaceRewriter(), IdentityMappingPolicy.Throw, MailAddressConversionPolicy.ToMailAddress, TypeOrder.TYPE_ORDER_3),
        Address("", new UserRewritter.ReplaceRewriter(), IdentityMappingPolicy.Throw, MailAddressConversionPolicy.ToMailAddress, TypeOrder.TYPE_ORDER_4);

        private final String asPrefix;
        private final UserRewritter.MappingUserRewriter rewriter;
        private final IdentityMappingPolicy identityMappingPolicy;
        private final MailAddressConversionPolicy mailAddressConversionPolicy;
        private final TypeOrder typeOrder;

        private Type(String asPrefix, UserRewritter.MappingUserRewriter rewriter, IdentityMappingPolicy identityMappingPolicy, MailAddressConversionPolicy mailAddressConversionPolicy, TypeOrder typeOrder) {
            this.asPrefix = asPrefix;
            this.rewriter = rewriter;
            this.identityMappingPolicy = identityMappingPolicy;
            this.mailAddressConversionPolicy = mailAddressConversionPolicy;
            this.typeOrder = typeOrder;
        }

        public String asPrefix() {
            return this.asPrefix;
        }

        public int getTypeOrder() {
            return this.typeOrder.ordinal();
        }

        public String withoutPrefix(String input) {
            Preconditions.checkArgument((boolean)input.startsWith(this.asPrefix));
            return input.substring(this.asPrefix.length());
        }

        public boolean hasPrefix() {
            return !this.asPrefix.isEmpty();
        }

        public static boolean hasPrefix(String mapping) {
            return Arrays.stream(Type.values()).filter(Type::hasPrefix).anyMatch(type -> mapping.startsWith(type.asPrefix()));
        }
    }

    public static class Impl
    implements Mapping,
    Serializable {
        private final Type type;
        private final String mapping;
        private final UserRewritter rewriter;

        private Impl(Type type, String mapping) {
            Preconditions.checkNotNull((Object)((Object)type));
            Preconditions.checkNotNull((Object)mapping);
            this.type = type;
            this.mapping = mapping;
            this.rewriter = type.rewriter.generateUserRewriter(mapping);
        }

        @Override
        public String asString() {
            return this.type.asPrefix() + this.mapping;
        }

        @Override
        public boolean hasDomain() {
            return this.mapping.contains("@");
        }

        @Override
        public Mapping appendDomainIfNone(Supplier<Domain> domain) {
            Preconditions.checkNotNull(domain);
            if (this.hasDomain()) {
                return this;
            }
            return this.appendDomain(domain.get());
        }

        @Override
        public Mapping appendDomainFromThrowingSupplierIfNone(ThrowingDomainSupplier supplier) throws RecipientRewriteTableException {
            Preconditions.checkNotNull((Object)supplier);
            if (this.hasDomain()) {
                return this;
            }
            return this.appendDomain(supplier.get());
        }

        private Mapping appendDomain(Domain domain) {
            return Mapping.of(this.type, this.mapping + "@" + domain.asString());
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public String getMappingValue() {
            return this.mapping;
        }

        @Override
        public String getErrorMessage() {
            Preconditions.checkState((this.getType() == Type.Error ? 1 : 0) != 0);
            return this.mapping;
        }

        @Override
        public Optional<Username> rewriteUser(Username username) throws AddressException, RecipientRewriteTable.ErrorMappingException {
            return this.rewriter.rewrite(username);
        }

        @Override
        public Stream<Mapping> handleIdentity(Stream<Mapping> nonRecursiveResult) {
            return this.type.identityMappingPolicy.handleIdentity(nonRecursiveResult);
        }

        @Override
        public Optional<MailAddress> asMailAddress() {
            return this.type.mailAddressConversionPolicy.convert(this.mapping);
        }

        public final boolean equals(Object other) {
            if (other instanceof Impl) {
                Impl otherMapping = (Impl)other;
                return Objects.equal((Object)((Object)this.type), (Object)((Object)otherMapping.type)) && Objects.equal((Object)this.mapping, (Object)otherMapping.mapping);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.mapping});
        }

        public String toString() {
            return "Mapping{type=" + this.type + " mapping=" + this.mapping + "}";
        }
    }

    public static interface ThrowingDomainSupplier {
        public Domain get() throws RecipientRewriteTableException;
    }

    public static enum IdentityMappingPolicy {
        Throw{

            @Override
            public Stream<Mapping> handleIdentity(Stream<Mapping> mapping) {
                throw new SkipMappingProcessingException();
            }
        }
        ,
        ReturnIdentity{

            @Override
            public Stream<Mapping> handleIdentity(Stream<Mapping> mapping) {
                return mapping;
            }
        };


        public abstract Stream<Mapping> handleIdentity(Stream<Mapping> var1);
    }

    public static enum TypeOrder {
        TYPE_ORDER_1,
        TYPE_ORDER_2,
        TYPE_ORDER_3,
        TYPE_ORDER_4;

    }

    public static enum MailAddressConversionPolicy {
        ToEmpty{

            @Override
            Optional<MailAddress> convert(String mapping) {
                return Optional.empty();
            }
        }
        ,
        ToMailAddress{

            @Override
            Optional<MailAddress> convert(String mapping) {
                try {
                    return Optional.of(new MailAddress(mapping));
                }
                catch (AddressException e) {
                    return Optional.empty();
                }
            }
        };


        abstract Optional<MailAddress> convert(String var1);
    }
}

