/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.model;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.quota.model.QuotaThresholdChange;

public class HistoryEvolution {
    private final HistoryChangeType thresholdHistoryChange;
    private final Optional<HighestThresholdRecentness> recentness;
    private final Optional<QuotaThresholdChange> thresholdChange;

    public static HistoryEvolution noChanges() {
        return new HistoryEvolution(HistoryChangeType.NoChange, Optional.empty(), Optional.empty());
    }

    public static HistoryEvolution lowerThresholdReached(QuotaThresholdChange currentThreshold) {
        return new HistoryEvolution(HistoryChangeType.LowerThresholdReached, Optional.empty(), Optional.of(currentThreshold));
    }

    public static HistoryEvolution higherThresholdReached(QuotaThresholdChange currentThreshold, HighestThresholdRecentness recentness) {
        return new HistoryEvolution(HistoryChangeType.HigherThresholdReached, Optional.of(recentness), Optional.of(currentThreshold));
    }

    public HistoryEvolution(HistoryChangeType thresholdHistoryChange, Optional<HighestThresholdRecentness> recentness, Optional<QuotaThresholdChange> thresholdChange) {
        this.thresholdHistoryChange = thresholdHistoryChange;
        this.recentness = recentness;
        this.thresholdChange = thresholdChange;
    }

    public boolean isChange() {
        return this.thresholdHistoryChange != HistoryChangeType.NoChange;
    }

    public boolean currentThresholdNotRecentlyReached() {
        return this.recentness.map(value -> value == HighestThresholdRecentness.NotAlreadyReachedDuringGracePeriod).orElse(false);
    }

    public Optional<QuotaThresholdChange> getThresholdChange() {
        return this.thresholdChange;
    }

    public HistoryChangeType getThresholdHistoryChange() {
        return this.thresholdHistoryChange;
    }

    public Optional<HighestThresholdRecentness> getRecentness() {
        return this.recentness;
    }

    public final boolean equals(Object o) {
        if (o instanceof HistoryEvolution) {
            HistoryEvolution that = (HistoryEvolution)o;
            return Objects.equals((Object)this.thresholdHistoryChange, (Object)that.thresholdHistoryChange) && Objects.equals(this.recentness, that.recentness) && Objects.equals(this.thresholdChange, that.thresholdChange);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.thresholdHistoryChange, this.recentness, this.thresholdChange});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("thresholdHistoryChange", (Object)this.thresholdHistoryChange).add("recentness", this.recentness).add("thresholdChange", this.thresholdChange).toString();
    }

    public static enum HistoryChangeType {
        HigherThresholdReached,
        NoChange,
        LowerThresholdReached;

    }

    public static enum HighestThresholdRecentness {
        AlreadyReachedDuringGracePeriod,
        NotAlreadyReachedDuringGracePeriod;

    }
}

