/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.james.jmap.draft.methods.ValidationResult;
import org.apache.james.jmap.draft.model.Attachment;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.Keyword;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.MessageProperties;
import org.apache.james.jmap.draft.model.OldKeyword;
import org.apache.james.jmap.draft.model.message.view.SubMessage;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.util.StreamUtils;

@JsonDeserialize(builder=Builder.class)
public class CreationMessage {
    private static final String RECIPIENT_PROPERTY_NAMES = ImmutableList.of((Object)MessageProperties.MessageProperty.to, (Object)MessageProperties.MessageProperty.cc, (Object)MessageProperties.MessageProperty.bcc).stream().map(MessageProperties.MessageProperty::asFieldName).collect(Collectors.joining(", "));
    private final ImmutableList<String> mailboxIds;
    private final Optional<String> inReplyToMessageId;
    private final ImmutableMap<String, String> headers;
    private final Optional<DraftEmailer> from;
    private final ImmutableList<DraftEmailer> to;
    private final ImmutableList<DraftEmailer> cc;
    private final ImmutableList<DraftEmailer> bcc;
    private final ImmutableList<DraftEmailer> replyTo;
    private final String subject;
    private final ZonedDateTime date;
    private final Optional<String> textBody;
    private final Optional<String> htmlBody;
    private final ImmutableList<Attachment> attachments;
    private final ImmutableMap<BlobId, SubMessage> attachedMessages;
    private final Keywords keywords;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    CreationMessage(ImmutableList<String> mailboxIds, Optional<String> inReplyToMessageId, ImmutableMap<String, String> headers, Optional<DraftEmailer> from, ImmutableList<DraftEmailer> to, ImmutableList<DraftEmailer> cc, ImmutableList<DraftEmailer> bcc, ImmutableList<DraftEmailer> replyTo, String subject, ZonedDateTime date, Optional<String> textBody, Optional<String> htmlBody, ImmutableList<Attachment> attachments, ImmutableMap<BlobId, SubMessage> attachedMessages, Keywords keywords) {
        this.mailboxIds = mailboxIds;
        this.inReplyToMessageId = inReplyToMessageId;
        this.headers = headers;
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.replyTo = replyTo;
        this.subject = subject;
        this.date = date;
        this.textBody = textBody;
        this.htmlBody = htmlBody;
        this.attachments = attachments;
        this.attachedMessages = attachedMessages;
        this.keywords = keywords;
    }

    public Keywords getKeywords() {
        return this.keywords;
    }

    public ImmutableList<String> getMailboxIds() {
        return this.mailboxIds;
    }

    public Optional<String> getInReplyToMessageId() {
        return this.inReplyToMessageId;
    }

    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    public Optional<DraftEmailer> getFrom() {
        return this.from;
    }

    public ImmutableList<DraftEmailer> getTo() {
        return this.to;
    }

    public ImmutableList<DraftEmailer> getCc() {
        return this.cc;
    }

    public ImmutableList<DraftEmailer> getBcc() {
        return this.bcc;
    }

    public ImmutableList<DraftEmailer> getReplyTo() {
        return this.replyTo;
    }

    public String getSubject() {
        return this.subject;
    }

    public ZonedDateTime getDate() {
        return this.date;
    }

    public Optional<String> getTextBody() {
        return this.textBody;
    }

    public Optional<String> getHtmlBody() {
        return this.htmlBody;
    }

    public ImmutableList<Attachment> getAttachments() {
        return this.attachments;
    }

    public ImmutableMap<BlobId, SubMessage> getAttachedMessages() {
        return this.attachedMessages;
    }

    public boolean isValid() {
        return this.validate().isEmpty();
    }

    public boolean isDraft() {
        return this.keywords.contains(Keyword.DRAFT);
    }

    public List<ValidationResult> validate() {
        ImmutableList.Builder errors = ImmutableList.builder();
        this.assertValidFromProvided((ImmutableList.Builder<ValidationResult>)errors);
        this.assertAtLeastOneValidRecipient((ImmutableList.Builder<ValidationResult>)errors);
        return errors.build();
    }

    private void assertAtLeastOneValidRecipient(ImmutableList.Builder<ValidationResult> errors) {
        Stream recipients = StreamUtils.flatten((Stream[])new Stream[]{this.to.stream(), this.cc.stream(), this.bcc.stream()});
        boolean hasAtLeastOneAddressToSendTo = recipients.anyMatch(DraftEmailer::hasValidEmail);
        if (!hasAtLeastOneAddressToSendTo) {
            errors.add((Object)ValidationResult.builder().message("no recipient address set").property(RECIPIENT_PROPERTY_NAMES).build());
        }
    }

    private void assertValidFromProvided(ImmutableList.Builder<ValidationResult> errors) {
        ValidationResult invalidPropertyFrom = ValidationResult.builder().property(MessageProperties.MessageProperty.from.asFieldName()).message("'from' address is mandatory").build();
        if (!this.from.isPresent()) {
            errors.add((Object)invalidPropertyFrom);
        }
        this.from.filter(f -> !f.hasValidEmail()).ifPresent(f -> errors.add((Object)invalidPropertyFrom));
    }

    public boolean isIn(MessageManager mailbox) {
        return this.mailboxIds.contains((Object)mailbox.getId().serialize());
    }

    public boolean isOnlyIn(MessageManager mailbox) {
        return this.isIn(mailbox) && this.mailboxIds.size() == 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mailboxIds", this.mailboxIds).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private ImmutableList<String> mailboxIds;
        private String inReplyToMessageId;
        private final OldKeyword.Builder oldKeywordBuilder;
        private final ImmutableMap.Builder<String, String> headers;
        private Optional<DraftEmailer> from = Optional.empty();
        private final ImmutableList.Builder<DraftEmailer> to;
        private final ImmutableList.Builder<DraftEmailer> cc;
        private final ImmutableList.Builder<DraftEmailer> bcc;
        private final ImmutableList.Builder<DraftEmailer> replyTo;
        private String subject;
        private ZonedDateTime date;
        private String textBody;
        private String htmlBody;
        private final ImmutableList.Builder<Attachment> attachments;
        private final ImmutableMap.Builder<BlobId, SubMessage> attachedMessages;
        private Optional<Map<String, Boolean>> keywords = Optional.empty();

        private Builder() {
            this.to = ImmutableList.builder();
            this.cc = ImmutableList.builder();
            this.bcc = ImmutableList.builder();
            this.replyTo = ImmutableList.builder();
            this.attachments = ImmutableList.builder();
            this.attachedMessages = ImmutableMap.builder();
            this.headers = ImmutableMap.builder();
            this.oldKeywordBuilder = OldKeyword.builder();
        }

        public Builder mailboxId(String ... mailboxIds) {
            return this.mailboxIds(Arrays.asList(mailboxIds));
        }

        @JsonDeserialize
        public Builder mailboxIds(List<String> mailboxIds) {
            this.mailboxIds = ImmutableList.copyOf(mailboxIds);
            return this;
        }

        public Builder inReplyToMessageId(String inReplyToMessageId) {
            this.inReplyToMessageId = inReplyToMessageId;
            return this;
        }

        public Builder isUnread(Optional<Boolean> isUnread) {
            this.oldKeywordBuilder.isUnread(isUnread);
            return this;
        }

        public Builder isFlagged(Optional<Boolean> isFlagged) {
            this.oldKeywordBuilder.isFlagged(isFlagged);
            return this;
        }

        public Builder isAnswered(Optional<Boolean> isAnswered) {
            this.oldKeywordBuilder.isAnswered(isAnswered);
            return this;
        }

        public Builder isDraft(Optional<Boolean> isDraft) {
            this.oldKeywordBuilder.isDraft(isDraft);
            return this;
        }

        public Builder isForwarded(Optional<Boolean> isForwarded) {
            this.oldKeywordBuilder.isForwarded(isForwarded);
            return this;
        }

        public Builder headers(ImmutableMap<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder from(DraftEmailer from) {
            this.from = Optional.ofNullable(from);
            return this;
        }

        public Builder to(List<DraftEmailer> to) {
            this.to.addAll(to);
            return this;
        }

        public Builder cc(List<DraftEmailer> cc) {
            this.cc.addAll(cc);
            return this;
        }

        public Builder bcc(List<DraftEmailer> bcc) {
            this.bcc.addAll(bcc);
            return this;
        }

        public Builder replyTo(List<DraftEmailer> replyTo) {
            this.replyTo.addAll(replyTo);
            return this;
        }

        public Builder subject(String subject) {
            this.subject = Strings.nullToEmpty((String)subject);
            return this;
        }

        public Builder date(ZonedDateTime date) {
            this.date = date;
            return this;
        }

        public Builder textBody(String textBody) {
            this.textBody = textBody;
            return this;
        }

        public Builder htmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public Builder attachments(Attachment ... attachments) {
            return this.attachments(Arrays.asList(attachments));
        }

        @JsonDeserialize
        public Builder attachments(List<Attachment> attachments) {
            this.attachments.addAll(attachments);
            return this;
        }

        public Builder attachedMessages(Map<BlobId, SubMessage> attachedMessages) {
            this.attachedMessages.putAll(attachedMessages);
            return this;
        }

        public Builder keywords(Map<String, Boolean> keywords) {
            this.keywords = Optional.of(ImmutableMap.copyOf(keywords));
            return this;
        }

        private static boolean areAttachedMessagesKeysInAttachments(ImmutableList<Attachment> attachments, ImmutableMap<BlobId, SubMessage> attachedMessages) {
            return attachedMessages.isEmpty() || attachedMessages.keySet().stream().anyMatch(Builder.inAttachments(attachments));
        }

        private static Predicate<BlobId> inAttachments(ImmutableList<Attachment> attachments) {
            return key -> attachments.stream().map(Attachment::getBlobId).anyMatch(blobId -> blobId.equals(key));
        }

        public CreationMessage build() {
            Preconditions.checkState((this.mailboxIds != null ? 1 : 0) != 0, (Object)"'mailboxIds' is mandatory");
            Preconditions.checkState((this.headers != null ? 1 : 0) != 0, (Object)"'headers' is mandatory");
            ImmutableList attachments = this.attachments.build();
            ImmutableMap attachedMessages = this.attachedMessages.build();
            Preconditions.checkState((boolean)Builder.areAttachedMessagesKeysInAttachments((ImmutableList<Attachment>)attachments, (ImmutableMap<BlobId, SubMessage>)attachedMessages), (Object)"'attachedMessages' keys must be in 'attachments'");
            if (this.date == null) {
                this.date = ZonedDateTime.now();
            }
            Optional<Keywords> maybeKeywords = this.creationKeywords();
            Optional<OldKeyword> oldKeywords = this.oldKeywordBuilder.computeOldKeyword();
            return new CreationMessage(this.mailboxIds, Optional.ofNullable(this.inReplyToMessageId), (ImmutableMap<String, String>)this.headers.build(), this.from, (ImmutableList<DraftEmailer>)this.to.build(), (ImmutableList<DraftEmailer>)this.cc.build(), (ImmutableList<DraftEmailer>)this.bcc.build(), (ImmutableList<DraftEmailer>)this.replyTo.build(), this.subject, this.date, Optional.ofNullable(this.textBody), Optional.ofNullable(this.htmlBody), (ImmutableList<Attachment>)attachments, (ImmutableMap<BlobId, SubMessage>)attachedMessages, this.computeKeywords(maybeKeywords, oldKeywords));
        }

        private Optional<Keywords> creationKeywords() {
            return this.keywords.map(map -> Keywords.strictFactory().fromMap((Map<String, Boolean>)map));
        }

        public Keywords computeKeywords(Optional<Keywords> keywords, Optional<OldKeyword> oldKeywords) {
            Preconditions.checkArgument((!keywords.isPresent() || !oldKeywords.isPresent() ? 1 : 0) != 0, (Object)"Does not support keyword and is* at the same time");
            return keywords.or(() -> oldKeywords.map(OldKeyword::asKeywords)).orElse(Keywords.DEFAULT_VALUE);
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static class DraftEmailer {
        private final Optional<String> name;
        private final Optional<String> email;
        private final EmailValidator emailValidator;

        public static Builder builder() {
            return new Builder();
        }

        @VisibleForTesting
        DraftEmailer(Optional<String> name, Optional<String> email) {
            this.name = name;
            this.email = email;
            this.emailValidator = new EmailValidator();
        }

        public Optional<String> getName() {
            return this.name;
        }

        public Optional<String> getEmail() {
            return this.email;
        }

        public boolean hasValidEmail() {
            return this.getEmail().isPresent() && this.emailValidator.isValid(this.getEmail().get());
        }

        public EmailUserAndDomain getEmailUserAndDomain() {
            int atIndex = this.email.get().indexOf(64);
            if (atIndex < 0 || atIndex == this.email.get().length() - 1) {
                return new EmailUserAndDomain(Optional.of(this.email.get()), Optional.empty());
            }
            String user = this.email.get().substring(0, atIndex);
            String domain = this.email.get().substring(atIndex + 1);
            return new EmailUserAndDomain(Optional.of(user), Optional.of(domain));
        }

        public boolean equals(Object o) {
            if (o instanceof DraftEmailer) {
                DraftEmailer otherEMailer = (DraftEmailer)o;
                return Objects.equals(this.name, otherEMailer.name) && Objects.equals(this.email.orElse("<unset>"), otherEMailer.email.orElse("<unset>"));
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.email);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", this.name).add("email", (Object)this.email.orElse("<unset>")).toString();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private Optional<String> name = Optional.empty();
            private Optional<String> email = Optional.empty();

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Builder email(String email) {
                this.email = Optional.ofNullable(email);
                return this;
            }

            public DraftEmailer build() {
                return new DraftEmailer(this.name, this.email);
            }
        }
    }

    public static class EmailValidator {
        public boolean isValid(String email) {
            boolean result = true;
            try {
                InternetAddress emailAddress = new InternetAddress(email);
                emailAddress.validate();
            }
            catch (AddressException ex) {
                result = false;
            }
            return result;
        }
    }

    public static class EmailUserAndDomain {
        private final Optional<String> user;
        private final Optional<String> domain;

        public EmailUserAndDomain(Optional<String> user, Optional<String> domain) {
            this.user = user;
            this.domain = domain;
        }

        public Optional<String> getUser() {
            return this.user;
        }

        public Optional<String> getDomain() {
            return this.domain;
        }
    }
}

