/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface UidProvider {
    public MessageUid nextUid(Mailbox var1) throws MailboxException;

    public Optional<MessageUid> lastUid(Mailbox var1) throws MailboxException;

    default public Mono<Optional<MessageUid>> lastUidReactive(Mailbox mailbox) {
        return Mono.fromCallable(() -> this.lastUid(mailbox));
    }

    public MessageUid nextUid(MailboxId var1) throws MailboxException;

    default public Mono<MessageUid> nextUidReactive(MailboxId mailboxId) {
        return Mono.fromCallable(() -> this.nextUid(mailboxId));
    }

    default public Mono<List<MessageUid>> nextUids(MailboxId mailboxId, int count) {
        return Flux.range((int)0, (int)count).flatMap(i -> this.nextUidReactive(mailboxId)).collect(ImmutableList.toImmutableList());
    }
}

