/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.delivery;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.server.core.MimeMessageUtil;
import org.apache.james.transport.mailets.delivery.MailboxAppender;
import org.apache.mailet.StorageDirective;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MailboxAppenderImpl
implements MailboxAppender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxAppenderImpl.class);
    private final MailboxManager mailboxManager;

    public MailboxAppenderImpl(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public Mono<ComposedMessageId> append(MimeMessage mail, Username user, StorageDirective storageDirective) throws MessagingException {
        Preconditions.checkArgument((boolean)storageDirective.getTargetFolder().isPresent(), (Object)"'targetFolder' field is needed");
        MailboxSession session = this.createMailboxSession(user);
        return this.append(mail, user, this.useSlashAsSeparator((String)storageDirective.getTargetFolder().get(), session), storageDirective.getFlags(), session).map(MessageManager.AppendResult::getId);
    }

    private String useSlashAsSeparator(String urlPath, MailboxSession session) throws MessagingException {
        String destination = urlPath.replace('/', session.getPathDelimiter());
        if (Strings.isNullOrEmpty((String)destination)) {
            throw new MessagingException("Mail can not be delivered to empty folder");
        }
        if (destination.charAt(0) == session.getPathDelimiter()) {
            destination = destination.substring(1);
        }
        return destination;
    }

    private Mono<MessageManager.AppendResult> append(MimeMessage mail, Username user, String folder, Optional<Flags> flags, MailboxSession mailboxSession) {
        MailboxPath mailboxPath = MailboxPath.forUser((Username)user, (String)folder);
        return Mono.using(() -> {
            this.mailboxManager.startProcessingRequest(mailboxSession);
            return mailboxSession;
        }, session -> this.appendMessageToMailbox(mail, (MailboxSession)session, mailboxPath, flags), this::closeProcessing).onErrorMap(MailboxException.class, e -> new MessagingException("Unable to access mailbox.", (Exception)e));
    }

    protected Mono<MessageManager.AppendResult> appendMessageToMailbox(MimeMessage mail, MailboxSession session, MailboxPath path, Optional<Flags> flags) {
        return this.createMailboxIfNotExist(session, path).flatMap(mailbox -> Mono.from((Publisher)mailbox.appendMessageReactive(this.appendCommand(flags).build(this.extractContent(mail)), session)));
    }

    private MessageManager.AppendCommand.Builder appendCommand(Optional<Flags> flags) {
        MessageManager.AppendCommand.Builder builder = MessageManager.AppendCommand.builder().recent().delivery();
        return flags.map(arg_0 -> ((MessageManager.AppendCommand.Builder)builder).withFlags(arg_0)).orElse(builder);
    }

    private Content extractContent(final MimeMessage mail) {
        return new Content(){

            public InputStream getInputStream() throws IOException {
                try {
                    return new MimeMessageInputStream(mail);
                }
                catch (MessagingException e) {
                    throw new IOException(e);
                }
            }

            public long size() throws MailboxException {
                try {
                    return MimeMessageUtil.getMessageSize((MimeMessage)mail);
                }
                catch (MessagingException e) {
                    throw new MailboxException("Cannot compute message size", (Throwable)e);
                }
            }
        };
    }

    private Mono<MessageManager> createMailboxIfNotExist(MailboxSession session, MailboxPath path) {
        return Mono.from((Publisher)this.mailboxManager.getMailboxReactive(path, session)).onErrorResume(MailboxNotFoundException.class, e -> Mono.from((Publisher)this.mailboxManager.createMailboxReactive(path, MailboxManager.CreateOption.CREATE_SUBSCRIPTION, session)).then(Mono.from((Publisher)this.mailboxManager.getMailboxReactive(path, session))).onErrorResume(MailboxExistsException.class, e2 -> {
            LOGGER.info("Mailbox {} have been created concurrently", (Object)path);
            return Mono.from((Publisher)this.mailboxManager.getMailboxReactive(path, session));
        }));
    }

    public MailboxSession createMailboxSession(Username user) {
        return this.mailboxManager.createSystemSession(user);
    }

    private void closeProcessing(MailboxSession session) {
        this.mailboxManager.endProcessingRequest(session);
    }
}

