/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.util.MDCBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class ReactorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactorUtils.class);
    public static final String MDC_KEY_PREFIX = "MDC-";
    public static final int DEFAULT_CONCURRENCY = 16;
    private static final int DEFAULT_BOUNDED_ELASTIC_SIZE = Optional.ofNullable(System.getProperty("james.schedulers.defaultBoundedElasticSize")).map(Integer::parseInt).orElseGet(() -> 10 * Runtime.getRuntime().availableProcessors());
    public static final int DEFAULT_BOUNDED_ELASTIC_QUEUESIZE = Optional.ofNullable(System.getProperty("james.schedulers.defaultBoundedElasticQueueSize")).map(Integer::parseInt).orElse(100000);
    private static final int TTL_SECONDS = 60;
    private static final boolean DAEMON = true;
    public static final Scheduler BLOCKING_CALL_WRAPPER = Schedulers.newBoundedElastic((int)DEFAULT_BOUNDED_ELASTIC_SIZE, (int)DEFAULT_BOUNDED_ELASTIC_QUEUESIZE, (String)"blocking-call-wrapper", (int)60, (boolean)true);

    public static <T, U> RequiresQuantity<T, U> throttle() {
        return elements -> duration -> operation -> {
            Preconditions.checkArgument((elements > 0 ? 1 : 0) != 0, (Object)"'windowMaxSize' must be strictly positive");
            Preconditions.checkArgument((!duration.isNegative() ? 1 : 0) != 0, (Object)"'windowDuration' must be strictly positive");
            Preconditions.checkArgument((!duration.isZero() ? 1 : 0) != 0, (Object)"'windowDuration' must be strictly positive");
            return flux -> flux.onErrorContinue((e, o) -> LOGGER.error("Error encountered while generating throttled entries", e)).window(elements).delayElements(duration).concatMap(window -> window.flatMap(operation, Queues.SMALL_BUFFER_SIZE).onErrorResume(e -> {
                LOGGER.error("Error encountered while throttling", e);
                return Mono.empty();
            }));
        };
    }

    public static <T> Mono<T> executeAndEmpty(Runnable runnable) {
        return Mono.fromRunnable((Runnable)runnable).then(Mono.empty());
    }

    public static <T> BiConsumer<Optional<T>, SynchronousSink<T>> publishIfPresent() {
        return (element, sink) -> element.ifPresent(arg_0 -> ((SynchronousSink)sink).next(arg_0));
    }

    public static InputStream toInputStream(Flux<ByteBuffer> byteArrays) {
        return new StreamInputStream(byteArrays.toStream(1));
    }

    public static Flux<ByteBuffer> toChunks(InputStream inputStream, int bufferSize) {
        return Flux.generate(sink -> {
            try {
                byte[] buffer = new byte[bufferSize];
                int read = inputStream.read(buffer);
                if (read >= 0) {
                    sink.next((Object)ByteBuffer.wrap(buffer, 0, read));
                } else {
                    sink.complete();
                }
            }
            catch (IOException e) {
                sink.error((Throwable)e);
            }
        }).defaultIfEmpty((Object)ByteBuffer.wrap(new byte[0]));
    }

    private static int byteToInt(ByteBuffer buffer) {
        return buffer.get() & 0xFF;
    }

    public static Consumer<Signal<?>> logOnError(Consumer<Throwable> errorLogStatement) {
        return signal -> {
            if (!signal.isOnError()) {
                return;
            }
            ReactorUtils.logWithContext(() -> errorLogStatement.accept(signal.getThrowable()), signal.getContextView());
        };
    }

    public static Consumer<Signal<?>> log(Runnable logStatement) {
        return signal -> ReactorUtils.logWithContext(logStatement, signal.getContextView());
    }

    private static void logWithContext(Runnable logStatement, ContextView contextView) {
        try (Closeable mdc = ReactorUtils.retrieveMDCBuilder(contextView).build();){
            logStatement.run();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Mono<Void> logAsMono(Runnable logStatement) {
        return Mono.deferContextual(contextView -> Mono.fromRunnable(() -> ReactorUtils.logWithContext(logStatement, contextView)));
    }

    public static Consumer<Signal<?>> logOnError(Class<? extends Throwable> clazz, Consumer<Throwable> errorLogStatement) {
        return signal -> {
            if (signal.hasError() && clazz.isInstance(signal.getThrowable())) {
                ReactorUtils.logWithContext(() -> errorLogStatement.accept(signal.getThrowable()), signal.getContextView());
            }
        };
    }

    public static Context context(String keySuffix, MDCBuilder mdcBuilder) {
        return Context.of((Object)ReactorUtils.mdcKey(keySuffix), (Object)mdcBuilder);
    }

    private static String mdcKey(String value) {
        return MDC_KEY_PREFIX + value;
    }

    public static MDCBuilder retrieveMDCBuilder(Signal<?> signal) {
        return ReactorUtils.retrieveMDCBuilder(signal.getContextView());
    }

    public static MDCBuilder retrieveMDCBuilder(ContextView context) {
        return context.stream().filter(entry -> entry.getKey() instanceof String).filter(entry -> entry.getValue() instanceof MDCBuilder).filter(entry -> ((String)entry.getKey()).startsWith(MDC_KEY_PREFIX)).map(entry -> (MDCBuilder)entry.getValue()).reduce(MDCBuilder.create(), MDCBuilder::addToContext);
    }

    @FunctionalInterface
    public static interface RequiresQuantity<T, U> {
        public RequiresPeriod<T, U> elements(int var1);
    }

    private static class StreamInputStream
    extends InputStream {
        private static final int NO_MORE_DATA = -1;
        private final Iterator<ByteBuffer> source;
        private final Stream<ByteBuffer> sourceAsStream;
        private Optional<ByteBuffer> currentItemByteStream;

        StreamInputStream(Stream<ByteBuffer> source) {
            this.source = source.iterator();
            this.sourceAsStream = source;
            this.currentItemByteStream = Optional.empty();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.nextNonEmptyBuffer().map(buffer -> {
                int toRead = Math.min(len, buffer.remaining());
                buffer.get(b, off, toRead);
                return toRead;
            }).orElse(-1);
        }

        @Override
        public int read() {
            return this.nextNonEmptyBuffer().map(x$0 -> ReactorUtils.byteToInt(x$0)).orElse(-1);
        }

        private Optional<ByteBuffer> nextNonEmptyBuffer() {
            Boolean needsNewBuffer = this.currentItemByteStream.map(buffer -> !buffer.hasRemaining()).orElse(true);
            if (needsNewBuffer.booleanValue()) {
                if (this.source.hasNext()) {
                    this.currentItemByteStream = Optional.of(this.source.next());
                    return this.nextNonEmptyBuffer();
                }
                return Optional.empty();
            }
            return this.currentItemByteStream;
        }

        @Override
        public void close() throws IOException {
            this.sourceAsStream.close();
        }
    }

    @FunctionalInterface
    public static interface RequiresPeriod<T, U> {
        public RequiresOperation<T, U> per(Duration var1);
    }

    @FunctionalInterface
    public static interface RequiresOperation<T, U> {
        public Function<Flux<T>, Flux<U>> forOperation(Function<T, Publisher<U>> var1);
    }
}

