/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.BooleanMatchingRule;
import com.unboundid.ldap.matchingrules.CaseExactStringMatchingRule;
import com.unboundid.ldap.matchingrules.CaseIgnoreListMatchingRule;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.DistinguishedNameMatchingRule;
import com.unboundid.ldap.matchingrules.GeneralizedTimeMatchingRule;
import com.unboundid.ldap.matchingrules.IntegerMatchingRule;
import com.unboundid.ldap.matchingrules.NumericStringMatchingRule;
import com.unboundid.ldap.matchingrules.OctetStringMatchingRule;
import com.unboundid.ldap.matchingrules.TelephoneNumberMatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectExactMatchingRule;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class MatchingRule
implements Serializable {
    public static final byte SUBSTRING_TYPE_SUBINITIAL = -128;
    public static final byte SUBSTRING_TYPE_SUBANY = -127;
    public static final byte SUBSTRING_TYPE_SUBFINAL = -126;
    private static final long serialVersionUID = 6050276733546358513L;

    protected MatchingRule() {
    }

    @Nullable
    public abstract String getEqualityMatchingRuleName();

    @Nullable
    public abstract String getEqualityMatchingRuleOID();

    @Nullable
    public String getEqualityMatchingRuleNameOrOID() {
        String name = this.getEqualityMatchingRuleName();
        if (name == null) {
            return this.getEqualityMatchingRuleOID();
        }
        return name;
    }

    @Nullable
    public abstract String getOrderingMatchingRuleName();

    @Nullable
    public abstract String getOrderingMatchingRuleOID();

    @Nullable
    public String getOrderingMatchingRuleNameOrOID() {
        String name = this.getOrderingMatchingRuleName();
        if (name == null) {
            return this.getOrderingMatchingRuleOID();
        }
        return name;
    }

    @Nullable
    public abstract String getSubstringMatchingRuleName();

    @Nullable
    public abstract String getSubstringMatchingRuleOID();

    @Nullable
    public String getSubstringMatchingRuleNameOrOID() {
        String name = this.getSubstringMatchingRuleName();
        if (name == null) {
            return this.getSubstringMatchingRuleOID();
        }
        return name;
    }

    public abstract boolean valuesMatch(@NotNull ASN1OctetString var1, @NotNull ASN1OctetString var2) throws LDAPException;

    public boolean matchesAnyValue(@NotNull ASN1OctetString assertionValue, @NotNull ASN1OctetString[] attributeValues) throws LDAPException {
        if (assertionValue == null || attributeValues == null || attributeValues.length == 0) {
            return false;
        }
        boolean exceptionOnEveryAttempt = true;
        LDAPException firstException = null;
        for (ASN1OctetString attributeValue : attributeValues) {
            try {
                if (this.valuesMatch(assertionValue, attributeValue)) {
                    return true;
                }
                exceptionOnEveryAttempt = false;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (firstException != null) continue;
                firstException = le;
            }
        }
        if (exceptionOnEveryAttempt) {
            throw firstException;
        }
        return false;
    }

    public abstract boolean matchesSubstring(@NotNull ASN1OctetString var1, @Nullable ASN1OctetString var2, @Nullable ASN1OctetString[] var3, @Nullable ASN1OctetString var4) throws LDAPException;

    public abstract int compareValues(@NotNull ASN1OctetString var1, @NotNull ASN1OctetString var2) throws LDAPException;

    @NotNull
    public abstract ASN1OctetString normalize(@NotNull ASN1OctetString var1) throws LDAPException;

    @NotNull
    public abstract ASN1OctetString normalizeSubstring(@NotNull ASN1OctetString var1, byte var2) throws LDAPException;

    @NotNull
    public static MatchingRule selectEqualityMatchingRule(@NotNull String attrName, @Nullable Schema schema) {
        return MatchingRule.selectEqualityMatchingRule(attrName, null, schema);
    }

    @NotNull
    public static MatchingRule selectEqualityMatchingRule(@Nullable String attrName, @Nullable String ruleID, @Nullable Schema schema) {
        if (ruleID != null) {
            return MatchingRule.selectEqualityMatchingRule(ruleID);
        }
        if (attrName == null || schema == null) {
            return MatchingRule.getDefaultEqualityMatchingRule();
        }
        AttributeTypeDefinition attrType = schema.getAttributeType(attrName);
        if (attrType == null) {
            return MatchingRule.getDefaultEqualityMatchingRule();
        }
        String mrName = attrType.getEqualityMatchingRule(schema);
        if (mrName != null) {
            return MatchingRule.selectEqualityMatchingRule(mrName);
        }
        String syntaxOID = attrType.getBaseSyntaxOID(schema);
        if (syntaxOID != null) {
            return MatchingRule.selectMatchingRuleForSyntax(syntaxOID);
        }
        return MatchingRule.getDefaultEqualityMatchingRule();
    }

    @NotNull
    public static MatchingRule selectEqualityMatchingRule(@NotNull String ruleID) {
        if (ruleID == null || ruleID.isEmpty()) {
            return MatchingRule.getDefaultEqualityMatchingRule();
        }
        String lowerName = StaticUtils.toLowerCase(ruleID);
        if (lowerName.equals(BooleanMatchingRule.LOWER_EQUALITY_RULE_NAME) || lowerName.equals("2.5.13.13")) {
            return BooleanMatchingRule.getInstance();
        }
        if (lowerName.equals(CaseExactStringMatchingRule.LOWER_EQUALITY_RULE_NAME) || lowerName.equals("2.5.13.5") || lowerName.equals("caseexactia5match") || lowerName.equals("1.3.6.1.4.1.1466.109.114.1")) {
            return CaseExactStringMatchingRule.getInstance();
        }
        if (lowerName.equals(CaseIgnoreListMatchingRule.LOWER_EQUALITY_RULE_NAME) || lowerName.equals("2.5.13.11")) {
            return CaseIgnoreListMatchingRule.getInstance();
        }
        if (lowerName.equals(CaseIgnoreStringMatchingRule.LOWER_EQUALITY_RULE_NAME) || lowerName.equals("2.5.13.2") || lowerName.equals("caseignoreia5match") || lowerName.equals("1.3.6.1.4.1.1466.109.114.2")) {
            return CaseIgnoreStringMatchingRule.getInstance();
        }
        if (lowerName.equals(DistinguishedNameMatchingRule.LOWER_EQUALITY_RULE_NAME) || lowerName.equals("2.5.13.1") || lowerName.equals("uniquemembermatch") || lowerName.equals("2.5.13.23")) {
            return DistinguishedNameMatchingRule.getInstance();
        }
        if (lowerName.equals(GeneralizedTimeMatchingRule.LOWER_EQUALITY_RULE_NAME) || lowerName.equals("2.5.13.27")) {
            return GeneralizedTimeMatchingRule.getInstance();
        }
        if (lowerName.equals(IntegerMatchingRule.LOWER_EQUALITY_RULE_NAME) || lowerName.equals("2.5.13.14")) {
            return IntegerMatchingRule.getInstance();
        }
        if (lowerName.equals(NumericStringMatchingRule.LOWER_EQUALITY_RULE_NAME) || lowerName.equals("2.5.13.8")) {
            return NumericStringMatchingRule.getInstance();
        }
        if (lowerName.equals(OctetStringMatchingRule.LOWER_EQUALITY_RULE_NAME) || lowerName.equals("2.5.13.17")) {
            return OctetStringMatchingRule.getInstance();
        }
        if (lowerName.equals(TelephoneNumberMatchingRule.LOWER_EQUALITY_RULE_NAME) || lowerName.equals("2.5.13.20")) {
            return TelephoneNumberMatchingRule.getInstance();
        }
        if (lowerName.equals("jsonobjectexactmatch") || lowerName.equals("1.3.6.1.4.1.30221.2.4.12")) {
            return JSONObjectExactMatchingRule.getInstance();
        }
        return MatchingRule.getDefaultEqualityMatchingRule();
    }

    @NotNull
    public static MatchingRule getDefaultEqualityMatchingRule() {
        return CaseIgnoreStringMatchingRule.getInstance();
    }

    @NotNull
    public static MatchingRule selectOrderingMatchingRule(@NotNull String attrName, @Nullable Schema schema) {
        return MatchingRule.selectOrderingMatchingRule(attrName, null, schema);
    }

    @NotNull
    public static MatchingRule selectOrderingMatchingRule(@Nullable String attrName, @Nullable String ruleID, @Nullable Schema schema) {
        MatchingRule mr;
        if (ruleID != null) {
            return MatchingRule.selectOrderingMatchingRule(ruleID);
        }
        if (attrName == null || schema == null) {
            return MatchingRule.getDefaultOrderingMatchingRule();
        }
        AttributeTypeDefinition attrType = schema.getAttributeType(attrName);
        if (attrType == null) {
            return MatchingRule.getDefaultOrderingMatchingRule();
        }
        String mrName = attrType.getOrderingMatchingRule(schema);
        if (mrName != null) {
            return MatchingRule.selectOrderingMatchingRule(mrName);
        }
        String emrName = attrType.getEqualityMatchingRule(schema);
        if (emrName != null && (mr = MatchingRule.selectEqualityMatchingRule(emrName)) != null && mr.getOrderingMatchingRuleOID() != null) {
            return mr;
        }
        String syntaxOID = attrType.getBaseSyntaxOID(schema);
        if (syntaxOID != null) {
            return MatchingRule.selectMatchingRuleForSyntax(syntaxOID);
        }
        return MatchingRule.getDefaultOrderingMatchingRule();
    }

    @NotNull
    public static MatchingRule selectOrderingMatchingRule(@NotNull String ruleID) {
        if (ruleID == null || ruleID.isEmpty()) {
            return MatchingRule.getDefaultOrderingMatchingRule();
        }
        String lowerName = StaticUtils.toLowerCase(ruleID);
        if (lowerName.equals(CaseExactStringMatchingRule.LOWER_ORDERING_RULE_NAME) || lowerName.equals("2.5.13.6")) {
            return CaseExactStringMatchingRule.getInstance();
        }
        if (lowerName.equals(CaseIgnoreStringMatchingRule.LOWER_ORDERING_RULE_NAME) || lowerName.equals("2.5.13.3")) {
            return CaseIgnoreStringMatchingRule.getInstance();
        }
        if (lowerName.equals(GeneralizedTimeMatchingRule.LOWER_ORDERING_RULE_NAME) || lowerName.equals("2.5.13.28")) {
            return GeneralizedTimeMatchingRule.getInstance();
        }
        if (lowerName.equals(IntegerMatchingRule.LOWER_ORDERING_RULE_NAME) || lowerName.equals("2.5.13.15")) {
            return IntegerMatchingRule.getInstance();
        }
        if (lowerName.equals(NumericStringMatchingRule.LOWER_ORDERING_RULE_NAME) || lowerName.equals("2.5.13.9")) {
            return NumericStringMatchingRule.getInstance();
        }
        if (lowerName.equals(OctetStringMatchingRule.LOWER_ORDERING_RULE_NAME) || lowerName.equals("2.5.13.18")) {
            return OctetStringMatchingRule.getInstance();
        }
        return MatchingRule.getDefaultOrderingMatchingRule();
    }

    @NotNull
    public static MatchingRule getDefaultOrderingMatchingRule() {
        return CaseIgnoreStringMatchingRule.getInstance();
    }

    @NotNull
    public static MatchingRule selectSubstringMatchingRule(@NotNull String attrName, @Nullable Schema schema) {
        return MatchingRule.selectSubstringMatchingRule(attrName, null, schema);
    }

    @NotNull
    public static MatchingRule selectSubstringMatchingRule(@Nullable String attrName, @Nullable String ruleID, @Nullable Schema schema) {
        MatchingRule mr;
        if (ruleID != null) {
            return MatchingRule.selectSubstringMatchingRule(ruleID);
        }
        if (attrName == null || schema == null) {
            return MatchingRule.getDefaultSubstringMatchingRule();
        }
        AttributeTypeDefinition attrType = schema.getAttributeType(attrName);
        if (attrType == null) {
            return MatchingRule.getDefaultSubstringMatchingRule();
        }
        String mrName = attrType.getSubstringMatchingRule(schema);
        if (mrName != null) {
            return MatchingRule.selectSubstringMatchingRule(mrName);
        }
        String emrName = attrType.getEqualityMatchingRule(schema);
        if (emrName != null && (mr = MatchingRule.selectEqualityMatchingRule(emrName)) != null && mr.getSubstringMatchingRuleOID() != null) {
            return mr;
        }
        String syntaxOID = attrType.getBaseSyntaxOID(schema);
        if (syntaxOID != null) {
            return MatchingRule.selectMatchingRuleForSyntax(syntaxOID);
        }
        return MatchingRule.getDefaultSubstringMatchingRule();
    }

    @NotNull
    public static MatchingRule selectSubstringMatchingRule(@NotNull String ruleID) {
        if (ruleID == null || ruleID.isEmpty()) {
            return MatchingRule.getDefaultSubstringMatchingRule();
        }
        String lowerName = StaticUtils.toLowerCase(ruleID);
        if (lowerName.equals(CaseExactStringMatchingRule.LOWER_SUBSTRING_RULE_NAME) || lowerName.equals("2.5.13.7") || lowerName.equals("caseexactia5substringsmatch")) {
            return CaseExactStringMatchingRule.getInstance();
        }
        if (lowerName.equals(CaseIgnoreListMatchingRule.LOWER_SUBSTRING_RULE_NAME) || lowerName.equals("2.5.13.12")) {
            return CaseIgnoreListMatchingRule.getInstance();
        }
        if (lowerName.equals(CaseIgnoreStringMatchingRule.LOWER_SUBSTRING_RULE_NAME) || lowerName.equals("2.5.13.4") || lowerName.equals("caseignoreia5substringsmatch") || lowerName.equals("1.3.6.1.4.1.1466.109.114.3")) {
            return CaseIgnoreStringMatchingRule.getInstance();
        }
        if (lowerName.equals(NumericStringMatchingRule.LOWER_SUBSTRING_RULE_NAME) || lowerName.equals("2.5.13.10")) {
            return NumericStringMatchingRule.getInstance();
        }
        if (lowerName.equals(OctetStringMatchingRule.LOWER_SUBSTRING_RULE_NAME) || lowerName.equals("2.5.13.19")) {
            return OctetStringMatchingRule.getInstance();
        }
        if (lowerName.equals(TelephoneNumberMatchingRule.LOWER_SUBSTRING_RULE_NAME) || lowerName.equals("2.5.13.21")) {
            return TelephoneNumberMatchingRule.getInstance();
        }
        return MatchingRule.getDefaultSubstringMatchingRule();
    }

    @NotNull
    public static MatchingRule getDefaultSubstringMatchingRule() {
        return CaseIgnoreStringMatchingRule.getInstance();
    }

    @NotNull
    public static MatchingRule selectMatchingRuleForSyntax(@NotNull String syntaxOID) {
        if (syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.7")) {
            return BooleanMatchingRule.getInstance();
        }
        if (syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.41")) {
            return CaseIgnoreListMatchingRule.getInstance();
        }
        if (syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.12") || syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.34")) {
            return DistinguishedNameMatchingRule.getInstance();
        }
        if (syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.24") || syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.53")) {
            return GeneralizedTimeMatchingRule.getInstance();
        }
        if (syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.27")) {
            return IntegerMatchingRule.getInstance();
        }
        if (syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.36")) {
            return NumericStringMatchingRule.getInstance();
        }
        if (syntaxOID.equals("1.3.6.1.4.1.4203.1.1.2") || syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.5") || syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.8") || syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.9") || syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.10") || syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.28") || syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.40")) {
            return OctetStringMatchingRule.getInstance();
        }
        if (syntaxOID.equals("1.3.6.1.4.1.1466.115.121.1.50")) {
            return TelephoneNumberMatchingRule.getInstance();
        }
        if (syntaxOID.equals("1.3.6.1.4.1.30221.2.3.4")) {
            return JSONObjectExactMatchingRule.getInstance();
        }
        return CaseIgnoreStringMatchingRule.getInstance();
    }
}

