/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.james.javax.MimeMultipartReport;
import org.apache.james.mdn.MDNReport;
import org.apache.james.mdn.MDNReportParser;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.BodyPartBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.message.MultipartBuilder;
import org.apache.james.mime4j.stream.NameValuePair;
import scala.util.Try;

public class MDN {
    private static final NameValuePair UTF_8_CHARSET = new NameValuePair("charset", Charsets.UTF_8.name());
    public static final String DISPOSITION_CONTENT_TYPE = "message/disposition-notification";
    public static final String REPORT_SUB_TYPE = "report";
    public static final String DISPOSITION_NOTIFICATION_REPORT_TYPE = "disposition-notification";
    private final String humanReadableText;
    private final MDNReport report;
    private final Optional<Message> message;

    public static Builder builder() {
        return new Builder();
    }

    public static MDN parse(Message message) throws MDNParseException {
        if (!message.isMultipart()) {
            throw new MDNParseContentTypeException("MDN Message must be multipart");
        }
        List bodyParts = ((Multipart)message.getBody()).getBodyParts();
        if (bodyParts.size() < 2) {
            throw new MDNParseBodyPartInvalidException("MDN Message must contain at least two parts");
        }
        try {
            Entity humanReadableTextEntity = (Entity)bodyParts.get(0);
            return (MDN)MDN.extractHumanReadableText(humanReadableTextEntity).flatMap(humanReadableText -> MDN.extractMDNReport((Entity)bodyParts.get(1)).map(report -> MDN.builder().humanReadableText((String)humanReadableText).report((MDNReport)report).message(MDN.extractOriginalMessage(bodyParts)).build())).orElseThrow(() -> new MDNParseException("MDN can not extract. Body part is invalid"));
        }
        catch (MDNParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MDNParseException(e.getMessage(), e);
        }
    }

    private static Optional<Message> extractOriginalMessage(List<Entity> bodyParts) {
        if (bodyParts.size() < 3) {
            return Optional.empty();
        }
        Entity originalMessagePart = bodyParts.get(2);
        return Optional.of(originalMessagePart.getBody()).filter(Message.class::isInstance).map(Message.class::cast);
    }

    public static Optional<String> extractHumanReadableText(Entity humanReadableTextEntity) throws IOException {
        if (humanReadableTextEntity.getMimeType().equals("text/plain")) {
            try (InputStream inputStream = ((SingleBody)humanReadableTextEntity.getBody()).getInputStream();){
                Optional<String> optional = Optional.of(IOUtils.toString((InputStream)inputStream, (String)humanReadableTextEntity.getCharset()));
                return optional;
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<MDNReport> extractMDNReport(Entity reportEntity) {
        if (!reportEntity.getMimeType().startsWith(DISPOSITION_CONTENT_TYPE)) {
            return Optional.empty();
        }
        try (InputStream inputStream = ((SingleBody)reportEntity.getBody()).getInputStream();){
            Try<MDNReport> result = MDNReportParser.parse(inputStream, reportEntity.getCharset());
            if (result.isSuccess()) {
                Optional<MDNReport> optional2 = Optional.of((MDNReport)result.get());
                return optional2;
            }
            Optional<MDNReport> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private MDN(String humanReadableText, MDNReport report, Optional<Message> message) {
        this.humanReadableText = humanReadableText;
        this.report = report;
        this.message = message;
    }

    public String getHumanReadableText() {
        return this.humanReadableText;
    }

    public MDNReport getReport() {
        return this.report;
    }

    public Optional<Message> getOriginalMessage() {
        return this.message;
    }

    public MimeMultipart asMultipart() throws MessagingException {
        MimeMultipartReport multipart = new MimeMultipartReport();
        multipart.setSubType(REPORT_SUB_TYPE);
        multipart.setReportType(DISPOSITION_NOTIFICATION_REPORT_TYPE);
        multipart.addBodyPart(this.computeHumanReadablePart());
        multipart.addBodyPart(this.computeReportPart());
        this.message.ifPresent(Throwing.consumer(originalMessage -> multipart.addBodyPart(this.computeOriginalMessagePart((Message)originalMessage))).sneakyThrow());
        return multipart;
    }

    public MimeMessage asMimeMessage() throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        mimeMessage.setContent((javax.mail.Multipart)this.asMultipart());
        return mimeMessage;
    }

    public BodyPart computeHumanReadablePart() throws MessagingException {
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText(this.humanReadableText, StandardCharsets.UTF_8.displayName());
        textPart.setDisposition("inline");
        return textPart;
    }

    public BodyPart computeReportPart() throws MessagingException {
        MimeBodyPart mdnPart = new MimeBodyPart();
        mdnPart.setContent((Object)this.report.formattedValue(), DISPOSITION_CONTENT_TYPE);
        return mdnPart;
    }

    public BodyPart computeOriginalMessagePart(Message message) throws MessagingException {
        MimeBodyPart originalMessagePart = new MimeBodyPart();
        try {
            ByteArrayDataSource source = new ByteArrayDataSource(DefaultMessageWriter.asBytes((Message)message), "message/rfc822");
            originalMessagePart.setDataHandler(new DataHandler((DataSource)source));
            return originalMessagePart;
        }
        catch (IOException e) {
            throw new MessagingException("Could not write message as bytes", (Exception)e);
        }
    }

    public Message.Builder asMime4JMessageBuilder() throws IOException {
        Message.Builder messageBuilder = Message.Builder.of();
        messageBuilder.setBody(this.asMime4JMultipart());
        return messageBuilder;
    }

    private Multipart asMime4JMultipart() throws IOException {
        MultipartBuilder builder = MultipartBuilder.create((String)REPORT_SUB_TYPE);
        builder.addContentTypeParameter(new NameValuePair("report-type", DISPOSITION_NOTIFICATION_REPORT_TYPE));
        builder.addBodyPart(BodyPartBuilder.create().use((BodyFactory)new BasicBodyFactory()).setBody(this.humanReadableText, Charsets.UTF_8).setContentType("text/plain", new NameValuePair[]{UTF_8_CHARSET}));
        builder.addBodyPart(BodyPartBuilder.create().use((BodyFactory)new BasicBodyFactory()).setBody(this.report.formattedValue(), Charsets.UTF_8).setContentType(DISPOSITION_CONTENT_TYPE, new NameValuePair[]{UTF_8_CHARSET}));
        return builder.build();
    }

    public final boolean equals(Object o) {
        if (o instanceof MDN) {
            MDN mdn = (MDN)o;
            return Objects.equals(this.humanReadableText, mdn.humanReadableText) && Objects.equals(this.report, mdn.report) && Objects.equals(this.message, mdn.message);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.humanReadableText, this.report, this.message);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("humanReadableText", (Object)this.humanReadableText).add(REPORT_SUB_TYPE, (Object)this.report).add("message", this.message).toString();
    }

    public static class Builder {
        private String humanReadableText;
        private MDNReport report;
        private Optional<Message> message = Optional.empty();

        public Builder report(MDNReport report) {
            Preconditions.checkNotNull((Object)report);
            this.report = report;
            return this;
        }

        public Builder humanReadableText(String humanReadableText) {
            Preconditions.checkNotNull((Object)humanReadableText);
            this.humanReadableText = humanReadableText;
            return this;
        }

        public Builder message(Optional<Message> message) {
            this.message = message;
            return this;
        }

        public MDN build() {
            Preconditions.checkState((this.report != null ? 1 : 0) != 0);
            Preconditions.checkState((this.humanReadableText != null ? 1 : 0) != 0);
            Preconditions.checkState((!this.humanReadableText.trim().isEmpty() ? 1 : 0) != 0);
            return new MDN(this.humanReadableText, this.report, this.message);
        }
    }

    public static class MDNParseContentTypeException
    extends MDNParseException {
        public MDNParseContentTypeException(String message) {
            super(message);
        }
    }

    public static class MDNParseBodyPartInvalidException
    extends MDNParseException {
        public MDNParseBodyPartInvalidException(String message) {
            super(message);
        }
    }

    public static class MDNParseException
    extends Exception {
        public MDNParseException(String message) {
            super(message);
        }

        public MDNParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

